/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.Map;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.EntityEquipmentPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public interface EquipmentHandler {
    @NotNull
    public ItemStack getItemInMainHand();

    public void setItemInMainHand(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getItemInOffHand();

    public void setItemInOffHand(@NotNull ItemStack var1);

    @NotNull
    default public ItemStack getItemInHand(@NotNull Player.Hand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case Player.Hand.MAIN -> this.getItemInMainHand();
            case Player.Hand.OFF -> this.getItemInOffHand();
        };
    }

    default public void setItemInHand(@NotNull Player.Hand hand, @NotNull ItemStack stack) {
        switch (hand) {
            case MAIN: {
                this.setItemInMainHand(stack);
                break;
            }
            case OFF: {
                this.setItemInOffHand(stack);
            }
        }
    }

    @NotNull
    public ItemStack getHelmet();

    public void setHelmet(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getChestplate();

    public void setChestplate(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getLeggings();

    public void setLeggings(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getBoots();

    public void setBoots(@NotNull ItemStack var1);

    @NotNull
    default public ItemStack getEquipment(@NotNull EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAIN_HAND -> this.getItemInMainHand();
            case EquipmentSlot.OFF_HAND -> this.getItemInOffHand();
            case EquipmentSlot.HELMET -> this.getHelmet();
            case EquipmentSlot.CHESTPLATE -> this.getChestplate();
            case EquipmentSlot.LEGGINGS -> this.getLeggings();
            case EquipmentSlot.BOOTS -> this.getBoots();
        };
    }

    default public void setEquipment(@NotNull EquipmentSlot slot, @NotNull ItemStack itemStack) {
        switch (slot) {
            case MAIN_HAND: {
                this.setItemInMainHand(itemStack);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(itemStack);
                break;
            }
            case HELMET: {
                this.setHelmet(itemStack);
                break;
            }
            case CHESTPLATE: {
                this.setChestplate(itemStack);
                break;
            }
            case LEGGINGS: {
                this.setLeggings(itemStack);
                break;
            }
            case BOOTS: {
                this.setBoots(itemStack);
            }
        }
    }

    default public boolean hasEquipment(@NotNull EquipmentSlot slot) {
        return !this.getEquipment(slot).isAir();
    }

    default public void syncEquipment(@NotNull EquipmentSlot slot) {
        Check.stateCondition((!(this instanceof Entity) ? 1 : 0) != 0, (String)"Only accessible for Entity");
        Entity entity = (Entity)((Object)this);
        ItemStack itemStack = this.getEquipment(slot);
        entity.sendPacketToViewers(new EntityEquipmentPacket(entity.getEntityId(), Map.of(slot, itemStack)));
    }

    @NotNull
    default public EntityEquipmentPacket getEquipmentsPacket() {
        Check.stateCondition((!(this instanceof Entity) ? 1 : 0) != 0, (String)"Only accessible for Entity");
        return new EntityEquipmentPacket(((Entity)((Object)this)).getEntityId(), Map.of(EquipmentSlot.MAIN_HAND, this.getItemInMainHand(), EquipmentSlot.OFF_HAND, this.getItemInOffHand(), EquipmentSlot.BOOTS, this.getBoots(), EquipmentSlot.LEGGINGS, this.getLeggings(), EquipmentSlot.CHESTPLATE, this.getChestplate(), EquipmentSlot.HELMET, this.getHelmet()));
    }
}

