/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.UnaryOperator;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryItemChangeEvent;
import net.minestom.server.event.inventory.PlayerInventoryItemChangeEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryClickHandler;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.TransactionOption;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.InventoryClickProcessor;
import net.minestom.server.inventory.condition.InventoryCondition;
import net.minestom.server.item.ItemStack;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public abstract sealed class AbstractInventory
implements InventoryClickHandler,
Taggable
permits Inventory, PlayerInventory {
    private static final VarHandle ITEM_UPDATER = MethodHandles.arrayElementVarHandle(ItemStack[].class);
    private final int size;
    protected final ItemStack[] itemStacks;
    protected final List<InventoryCondition> inventoryConditions = new CopyOnWriteArrayList<InventoryCondition>();
    protected final InventoryClickProcessor clickProcessor = new InventoryClickProcessor();
    private final TagHandler tagHandler = TagHandler.newHandler();

    protected AbstractInventory(int size) {
        this.size = size;
        this.itemStacks = new ItemStack[this.getSize()];
        Arrays.fill(this.itemStacks, ItemStack.AIR);
    }

    public synchronized void setItemStack(int slot, @NotNull ItemStack itemStack) {
        Check.argCondition((!MathUtils.isBetween((int)slot, (int)0, (int)this.getSize()) ? 1 : 0) != 0, (String)("Inventory does not have the slot " + slot));
        this.safeItemInsert(slot, itemStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void safeItemInsert(int slot, @NotNull ItemStack itemStack, boolean sendPacket) {
        ItemStack previous;
        AbstractInventory abstractInventory = this;
        synchronized (abstractInventory) {
            Check.argCondition((!MathUtils.isBetween((int)slot, (int)0, (int)this.getSize()) ? 1 : 0) != 0, (String)"The slot {0} does not exist in this inventory", (Object[])new Object[]{slot});
            previous = this.itemStacks[slot];
            if (itemStack.equals(previous)) {
                return;
            }
            this.UNSAFE_itemInsert(slot, itemStack, sendPacket);
        }
        AbstractInventory abstractInventory2 = this;
        if (abstractInventory2 instanceof PlayerInventory) {
            PlayerInventory inv = (PlayerInventory)abstractInventory2;
            EventDispatcher.call(new PlayerInventoryItemChangeEvent(inv.player, slot, previous, itemStack));
        } else {
            abstractInventory2 = this;
            if (abstractInventory2 instanceof Inventory) {
                Inventory inv = (Inventory)abstractInventory2;
                EventDispatcher.call(new InventoryItemChangeEvent(inv, slot, previous, itemStack));
            }
        }
    }

    protected final void safeItemInsert(int slot, @NotNull ItemStack itemStack) {
        this.safeItemInsert(slot, itemStack, true);
    }

    protected abstract void UNSAFE_itemInsert(int var1, @NotNull ItemStack var2, boolean var3);

    @NotNull
    public synchronized <T> T processItemStack(@NotNull ItemStack itemStack, @NotNull TransactionType type, @NotNull TransactionOption<T> option) {
        return option.fill(type, this, itemStack);
    }

    @NotNull
    public synchronized <T> @NotNull List<@NotNull T> processItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionType type, @NotNull TransactionOption<T> option) {
        ArrayList result = new ArrayList(itemStacks.size());
        itemStacks.forEach(itemStack -> {
            Object transactionResult = this.processItemStack((ItemStack)itemStack, type, option);
            result.add(transactionResult);
        });
        return result;
    }

    @NotNull
    public <T> T addItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return this.processItemStack(itemStack, TransactionType.ADD, option);
    }

    public boolean addItemStack(@NotNull ItemStack itemStack) {
        return this.addItemStack(itemStack, TransactionOption.ALL_OR_NOTHING);
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> addItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionOption<T> option) {
        return this.processItemStacks(itemStacks, TransactionType.ADD, option);
    }

    @NotNull
    public <T> T takeItemStack(@NotNull ItemStack itemStack, @NotNull TransactionOption<T> option) {
        return this.processItemStack(itemStack, TransactionType.TAKE, option);
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> takeItemStacks(@NotNull @NotNull List<@NotNull ItemStack> itemStacks, @NotNull TransactionOption<T> option) {
        return this.processItemStacks(itemStacks, TransactionType.TAKE, option);
    }

    public synchronized void replaceItemStack(int slot, @NotNull @NotNull UnaryOperator<@NotNull ItemStack> operator) {
        ItemStack currentItem = this.getItemStack(slot);
        this.setItemStack(slot, (ItemStack)operator.apply(currentItem));
    }

    public synchronized void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.safeItemInsert(i, ItemStack.AIR, false);
        }
        this.update();
    }

    public abstract void update();

    @NotNull
    public ItemStack getItemStack(int slot) {
        return ITEM_UPDATER.getVolatile(this.itemStacks, slot);
    }

    @NotNull
    public ItemStack[] getItemStacks() {
        return (ItemStack[])this.itemStacks.clone();
    }

    public int getSize() {
        return this.size;
    }

    public int getInnerSize() {
        return this.getSize();
    }

    @NotNull
    public @NotNull List<@NotNull InventoryCondition> getInventoryConditions() {
        return this.inventoryConditions;
    }

    public void addInventoryCondition(@NotNull InventoryCondition inventoryCondition) {
        this.inventoryConditions.add(inventoryCondition);
    }

    public void copyContents(@NotNull ItemStack[] itemStacks) {
        Check.argCondition((itemStacks.length != this.getSize() ? 1 : 0) != 0, (String)("The size of the array has to be of the same size as the inventory: " + this.getSize()));
        for (int i = 0; i < itemStacks.length; ++i) {
            ItemStack itemStack = itemStacks[i];
            Check.notNull((Object)itemStack, (String)"The item array cannot contain any null element!");
            this.setItemStack(i, itemStack);
        }
    }

    @Override
    @NotNull
    public TagHandler tagHandler() {
        return this.tagHandler;
    }
}

