/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.jukebox;

import net.kyori.adventure.text.Component;
import net.minestom.server.instance.block.jukebox.JukeboxSongImpl;
import net.minestom.server.instance.block.jukebox.JukeboxSongs;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface JukeboxSong
extends ProtocolObject,
JukeboxSongs
permits JukeboxSongImpl {
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<JukeboxSong>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::jukeboxSong);
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<JukeboxSong>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::jukeboxSong);

    @NotNull
    public static JukeboxSong create(@NotNull SoundEvent soundEvent, @NotNull Component description, float lengthInSeconds, int comparatorOutput) {
        return new JukeboxSongImpl(soundEvent, description, lengthInSeconds, comparatorOutput, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<JukeboxSong> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:jukebox_song", JukeboxSongImpl.REGISTRY_NBT_TYPE, Registry.Resource.JUKEBOX_SONGS, (namespace, props) -> new JukeboxSongImpl(Registry.jukeboxSong(namespace, props)));
    }

    @NotNull
    public SoundEvent soundEvent();

    @NotNull
    public Component description();

    public float lengthInSeconds();

    public int comparatorOutput();

    @Nullable
    public Registry.JukeboxSongEntry registry();

    public static final class Builder {
        private SoundEvent soundEvent;
        private Component description;
        private float lengthInSeconds;
        private int comparatorOutput = 0;

        private Builder() {
        }

        @NotNull
        public Builder soundEvent(@NotNull SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Builder lengthInSeconds(float lengthInSeconds) {
            this.lengthInSeconds = lengthInSeconds;
            return this;
        }

        @NotNull
        public Builder comparatorOutput(int comparatorOutput) {
            this.comparatorOutput = comparatorOutput;
            return this;
        }

        @NotNull
        public JukeboxSong build() {
            return new JukeboxSongImpl(this.soundEvent, this.description, this.lengthInSeconds, this.comparatorOutput, null);
        }
    }
}

