/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.banner;

import net.minestom.server.instance.block.banner.BannerPatternImpl;
import net.minestom.server.instance.block.banner.BannerPatterns;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface BannerPattern
extends ProtocolObject,
BannerPatterns
permits BannerPatternImpl {
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<BannerPattern>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::bannerPattern);
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<BannerPattern>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::bannerPattern);

    @NotNull
    public static BannerPattern create(@NotNull NamespaceID assetId, @NotNull String translationKey) {
        return new BannerPatternImpl(assetId, translationKey, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<BannerPattern> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:banner_pattern", BannerPatternImpl.REGISTRY_NBT_TYPE, Registry.Resource.BANNER_PATTERNS, (namespace, props) -> new BannerPatternImpl(Registry.bannerPattern(namespace, props)));
    }

    @NotNull
    public NamespaceID assetId();

    @NotNull
    public String translationKey();

    @Nullable
    public Registry.BannerPatternEntry registry();

    public static final class Builder {
        private NamespaceID assetId;
        private String translationKey;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull NamespaceID assetId) {
            this.assetId = assetId;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder translationKey(@NotNull String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public BannerPattern build() {
            return new BannerPatternImpl(this.assetId, this.translationKey, null);
        }
    }
}

