/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.instance.InstanceRegisterEvent;
import net.minestom.server.event.instance.InstanceUnregisterEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstanceManager {
    private final Registries registries;
    private final Set<Instance> instances = new CopyOnWriteArraySet<Instance>();

    public InstanceManager(@NotNull Registries registries) {
        this.registries = registries;
    }

    public void registerInstance(@NotNull Instance instance) {
        Check.stateCondition((boolean)(instance instanceof SharedInstance), (String)"Please use InstanceManager#registerSharedInstance to register a shared instance");
        this.UNSAFE_registerInstance(instance);
    }

    @ApiStatus.Experimental
    @NotNull
    public InstanceContainer createInstanceContainer(@NotNull DynamicRegistry.Key<DimensionType> dimensionType, @Nullable IChunkLoader loader) {
        InstanceContainer instanceContainer = new InstanceContainer(this.registries.dimensionType(), UUID.randomUUID(), dimensionType, loader, dimensionType.namespace());
        this.registerInstance(instanceContainer);
        return instanceContainer;
    }

    @NotNull
    public InstanceContainer createInstanceContainer(@NotNull DynamicRegistry.Key<DimensionType> dimensionType) {
        return this.createInstanceContainer(dimensionType, null);
    }

    @ApiStatus.Experimental
    @NotNull
    public InstanceContainer createInstanceContainer(@Nullable IChunkLoader loader) {
        return this.createInstanceContainer(DimensionType.OVERWORLD, loader);
    }

    @NotNull
    public InstanceContainer createInstanceContainer() {
        return this.createInstanceContainer(DimensionType.OVERWORLD, null);
    }

    @NotNull
    public SharedInstance registerSharedInstance(@NotNull SharedInstance sharedInstance) {
        InstanceContainer instanceContainer = sharedInstance.getInstanceContainer();
        Check.notNull((Object)instanceContainer, (String)"SharedInstance needs to have an InstanceContainer to be created!");
        instanceContainer.addSharedInstance(sharedInstance);
        this.UNSAFE_registerInstance(sharedInstance);
        return sharedInstance;
    }

    @NotNull
    public SharedInstance createSharedInstance(@NotNull InstanceContainer instanceContainer) {
        Check.notNull((Object)instanceContainer, (String)"Instance container cannot be null when creating a SharedInstance!");
        Check.stateCondition((!instanceContainer.isRegistered() ? 1 : 0) != 0, (String)"The container needs to be register in the InstanceManager");
        SharedInstance sharedInstance = new SharedInstance(UUID.randomUUID(), instanceContainer);
        return this.registerSharedInstance(sharedInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInstance(@NotNull Instance instance) {
        long onlinePlayers = instance.getPlayers().stream().filter(Player::isOnline).count();
        Check.stateCondition((onlinePlayers > 0L ? 1 : 0) != 0, (String)"You cannot unregister an instance with players inside.");
        Instance instance2 = instance;
        synchronized (instance2) {
            InstanceUnregisterEvent event = new InstanceUnregisterEvent(instance);
            EventDispatcher.call(event);
            if (instance instanceof InstanceContainer) {
                instance.getChunks().forEach(instance::unloadChunk);
                ThreadDispatcher<Chunk> dispatcher = MinecraftServer.process().dispatcher();
                instance.getChunks().forEach(dispatcher::deletePartition);
            }
            instance.setRegistered(false);
            this.instances.remove(instance);
        }
    }

    @NotNull
    public @NotNull Set<@NotNull Instance> getInstances() {
        return Collections.unmodifiableSet(this.instances);
    }

    @Nullable
    public Instance getInstance(@NotNull UUID uuid) {
        Optional<Instance> instance = this.getInstances().stream().filter(someInstance -> someInstance.getUniqueId().equals(uuid)).findFirst();
        return instance.orElse(null);
    }

    private void UNSAFE_registerInstance(@NotNull Instance instance) {
        instance.setRegistered(true);
        this.instances.add(instance);
        ThreadDispatcher<Chunk> dispatcher = MinecraftServer.process().dispatcher();
        instance.getChunks().forEach(dispatcher::createPartition);
        InstanceRegisterEvent event = new InstanceRegisterEvent(instance);
        EventDispatcher.call(event);
    }
}

