/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.velocity;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public final class VelocityProxy {
    public static final String PLAYER_INFO_CHANNEL = "velocity:player_info";
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    private static final String MAC_ALGORITHM = "HmacSHA256";
    private static volatile boolean enabled;
    private static Key key;

    public static void enable(@NotNull String secret) {
        Check.stateCondition((boolean)enabled, (String)"Velocity modern forwarding is already enabled");
        Check.stateCondition((boolean)MojangAuth.isEnabled(), (String)"Velocity modern forwarding should not be enabled with MojangAuth");
        enabled = true;
        key = new SecretKeySpec(secret.getBytes(), MAC_ALGORITHM);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean checkIntegrity(@NotNull NetworkBuffer buffer) {
        byte[] signature = new byte[32];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = buffer.read(NetworkBuffer.BYTE);
        }
        int index = buffer.readIndex();
        byte[] data = buffer.read(NetworkBuffer.RAW_BYTES);
        buffer.readIndex(index);
        try {
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(key);
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        int version = buffer.read(NetworkBuffer.VAR_INT);
        return version == 1;
    }
}

