/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query.response;

import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public class BasicQueryResponse
implements NetworkBuffer.Writer {
    private String motd = "A Minestom Server";
    private String gametype = "SMP";
    private String map = "world";
    private String numPlayers = String.valueOf(MinecraftServer.getConnectionManager().getOnlinePlayerCount());
    private String maxPlayers = String.valueOf(Integer.parseInt(this.numPlayers) + 1);

    @NotNull
    public String getMotd() {
        return this.motd;
    }

    public void setMotd(@NotNull String motd) {
        this.motd = Objects.requireNonNull(motd, "motd");
    }

    @NotNull
    public String getGametype() {
        return this.gametype;
    }

    public void setGametype(@NotNull String gametype) {
        this.gametype = Objects.requireNonNull(gametype, "gametype");
    }

    @NotNull
    public String getMap() {
        return this.map;
    }

    public void setMap(@NotNull String map) {
        this.map = Objects.requireNonNull(map, "map");
    }

    @NotNull
    public String getNumPlayers() {
        return this.numPlayers;
    }

    public void setNumPlayers(@NotNull String numPlayers) {
        this.numPlayers = Objects.requireNonNull(numPlayers, "numPlayers");
    }

    public void setNumPlayers(int numPlayers) {
        this.setNumPlayers(String.valueOf(numPlayers));
    }

    @NotNull
    public String getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(@NotNull String maxPlayers) {
        this.maxPlayers = Objects.requireNonNull(maxPlayers, "maxPlayers");
    }

    public void setMaxPlayers(int maxPlayers) {
        this.setMaxPlayers(String.valueOf(maxPlayers));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING_TERMINATED, this.motd);
        writer.write(NetworkBuffer.STRING_TERMINATED, this.gametype);
        writer.write(NetworkBuffer.STRING_TERMINATED, this.map);
        writer.write(NetworkBuffer.STRING_TERMINATED, this.numPlayers);
        writer.write(NetworkBuffer.STRING_TERMINATED, this.maxPlayers);
        writer.write(NetworkBuffer.SHORT, (short)MinecraftServer.getServer().getPort());
        writer.write(NetworkBuffer.STRING_TERMINATED, Objects.requireNonNullElse(MinecraftServer.getServer().getAddress(), ""));
    }
}

