/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.lan;

import java.time.Duration;
import java.util.Objects;
import net.minestom.server.timer.TimeUnit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OpenToLANConfig {
    int port = 0;
    Duration delayBetweenPings = Duration.of(1500L, TimeUnit.MILLISECOND);
    Duration delayBetweenEvent = Duration.of(30L, TimeUnit.SECOND);

    @Contract(value="_ -> this")
    @NotNull
    public OpenToLANConfig port(int port) {
        this.port = port;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public OpenToLANConfig pingDelay(@NotNull Duration delay) {
        this.delayBetweenPings = Objects.requireNonNull(delay, "delay");
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public OpenToLANConfig eventCallDelay(@NotNull Duration delay) {
        this.delayBetweenEvent = Objects.requireNonNull(delay, "delay");
        return this;
    }
}

