/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.followers;

import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.PositionUtils;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.pathfinding.followers.NodeFollower;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroundNodeFollower
implements NodeFollower {
    private final Entity entity;

    public GroundNodeFollower(@NotNull Entity entity) {
        this.entity = entity;
    }

    @Override
    public void moveTowards(@NotNull Point direction, double speed, @NotNull Point lookAt) {
        Pos position = this.entity.getPosition();
        double dx = direction.x() - position.x();
        double dy = direction.y() - position.y();
        double dz = direction.z() - position.z();
        double dxLook = lookAt.x() - position.x();
        double dyLook = lookAt.y() - position.y();
        double dzLook = lookAt.z() - position.z();
        double distSquared = dx * dx + dy * dy + dz * dz;
        if (speed > distSquared) {
            speed = distSquared;
        }
        double radians = Math.atan2(dz, dx);
        double speedX = Math.cos(radians) * speed;
        double speedZ = Math.sin(radians) * speed;
        float yaw = PositionUtils.getLookYaw((double)dxLook, (double)dzLook);
        float pitch = PositionUtils.getLookPitch((double)dxLook, (double)dyLook, (double)dzLook);
        PhysicsResult physicsResult = CollisionUtils.handlePhysics(this.entity, new Vec(speedX, 0.0, speedZ));
        this.entity.refreshPosition(Pos.fromPoint((Point)physicsResult.newPosition()).withView(yaw, pitch));
    }

    @Override
    public void jump(@Nullable Point point, @Nullable Point target) {
        if (this.entity.isOnGround()) {
            this.jump(4.0f);
        }
    }

    @Override
    public boolean isAtPoint(@NotNull Point point) {
        return this.entity.getPosition().sameBlock(point);
    }

    public void jump(float height) {
        this.entity.setVelocity(new Vec(0.0, (double)(height * 2.5f), 0.0));
    }

    @Override
    public double movementSpeed() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue();
        }
        return 0.1f;
    }
}

