/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import org.jetbrains.annotations.NotNull;

public class TurtleMeta
extends AnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 23;

    public TurtleMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public Point getHomePosition() {
        return (Point)this.metadata.getIndex(17, Vec.ZERO);
    }

    public void setBlockPosition(@NotNull Point value) {
        this.metadata.setIndex(17, Metadata.BlockPosition(value));
    }

    public boolean isHasEgg() {
        return this.metadata.getIndex(18, false);
    }

    public void setHasEgg(boolean value) {
        this.metadata.setIndex(18, Metadata.Boolean(value));
    }

    public boolean isLayingEgg() {
        return this.metadata.getIndex(19, false);
    }

    public void setLayingEgg(boolean value) {
        this.metadata.setIndex(19, Metadata.Boolean(value));
    }

    @NotNull
    public Point getTravelPosition() {
        return (Point)this.metadata.getIndex(20, Vec.ZERO);
    }

    public void setTravelPosition(@NotNull Point value) {
        this.metadata.setIndex(20, Metadata.BlockPosition(value));
    }

    public boolean isGoingHome() {
        return this.metadata.getIndex(21, false);
    }

    public void setGoingHome(boolean value) {
        this.metadata.setIndex(21, Metadata.Boolean(value));
    }

    public boolean isTravelling() {
        return this.metadata.getIndex(22, false);
    }

    public void setTravelling(boolean value) {
        this.metadata.setIndex(22, Metadata.Boolean(value));
    }
}

