/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.target;

import java.util.Comparator;
import java.util.function.Predicate;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.ai.TargetSelector;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.NotNull;

public class ClosestEntityTarget
extends TargetSelector {
    private final double range;
    private final Predicate<Entity> targetPredicate;

    @SafeVarargs
    @Deprecated
    public ClosestEntityTarget(@NotNull EntityCreature entityCreature, float range, Class<? extends LivingEntity> ... entitiesTarget) {
        this(entityCreature, (double)range, (Entity ent) -> {
            Class<?> clazz = ent.getClass();
            for (Class targetClass : entitiesTarget) {
                if (!targetClass.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        });
    }

    public ClosestEntityTarget(@NotNull EntityCreature entityCreature, double range, @NotNull Predicate<Entity> targetPredicate) {
        super(entityCreature);
        this.range = range;
        this.targetPredicate = targetPredicate;
    }

    @Override
    public Entity findTarget() {
        Instance instance = this.entityCreature.getInstance();
        if (instance == null) {
            return null;
        }
        return instance.getNearbyEntities((Point)this.entityCreature.getPosition(), this.range).stream().filter(ent -> !this.entityCreature.equals(ent) && !ent.isRemoved()).filter(this.targetPredicate).min(Comparator.comparingDouble(e -> e.getDistanceSquared(this.entityCreature))).orElse(null);
    }
}

