/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.function.Function;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.EntityProjectile;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.entity.pathfinding.Navigator;
import net.minestom.server.timer.Cooldown;
import net.minestom.server.timer.TimeUnit;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public class RangedAttackGoal
extends GoalSelector {
    private final Cooldown cooldown = new Cooldown(Duration.of(5L, TimeUnit.SERVER_TICK));
    private long lastShot;
    private final Duration delay;
    private final int attackRangeSquared;
    private final int desirableRangeSquared;
    private final boolean comeClose;
    private final double power;
    private final double spread;
    private ProjectileGenerator projectileGenerator;
    private boolean stop;
    private Entity cachedTarget;

    public RangedAttackGoal(@NotNull EntityCreature entityCreature, int delay, int attackRange, int desirableRange, boolean comeClose, double power, double spread, @NotNull TemporalUnit timeUnit) {
        this(entityCreature, Duration.of(delay, timeUnit), attackRange, desirableRange, comeClose, power, spread);
    }

    public RangedAttackGoal(@NotNull EntityCreature entityCreature, Duration delay, int attackRange, int desirableRange, boolean comeClose, double power, double spread) {
        super(entityCreature);
        this.delay = delay;
        this.attackRangeSquared = attackRange * attackRange;
        this.desirableRangeSquared = desirableRange * desirableRange;
        this.comeClose = comeClose;
        this.power = power;
        this.spread = spread;
        Check.argCondition((desirableRange > attackRange ? 1 : 0) != 0, (String)"Desirable range can not exceed attack range!");
    }

    public Cooldown getCooldown() {
        return this.cooldown;
    }

    public void setProjectileGenerator(ProjectileGenerator projectileGenerator) {
        this.projectileGenerator = projectileGenerator;
    }

    public void setProjectileGenerator(Function<Entity, EntityProjectile> projectileGenerator) {
        this.projectileGenerator = (shooter, target, pow, spr) -> {
            EntityProjectile projectile = (EntityProjectile)projectileGenerator.apply(shooter);
            projectile.setInstance(shooter.getInstance(), shooter.getPosition().add(0.0, shooter.getEyeHeight(), 0.0));
            projectile.shoot((Point)target, pow, spr);
        };
    }

    private ProjectileGenerator getProjectileGeneratorOrDefault() {
        if (this.projectileGenerator == null) {
            this.setProjectileGenerator((Entity shooter) -> new EntityProjectile((Entity)shooter, EntityType.ARROW));
        }
        return this.projectileGenerator;
    }

    @Override
    public boolean shouldStart() {
        this.cachedTarget = this.findTarget();
        return this.cachedTarget != null;
    }

    @Override
    public void start() {
        this.entityCreature.getNavigator().setPathTo((Point)this.cachedTarget.getPosition());
    }

    @Override
    public void tick(long time) {
        Entity target;
        if (this.cachedTarget != null) {
            target = this.cachedTarget;
            this.cachedTarget = null;
        } else {
            target = this.findTarget();
        }
        if (target == null) {
            this.stop = true;
            return;
        }
        double distanceSquared = this.entityCreature.getDistanceSquared(target);
        boolean comeClose = false;
        if (distanceSquared <= (double)this.attackRangeSquared && !Cooldown.hasCooldown(time, this.lastShot, this.delay)) {
            if (this.entityCreature.hasLineOfSight(target)) {
                Pos to = target.getPosition().add(0.0, target.getEyeHeight(), 0.0);
                this.getProjectileGeneratorOrDefault().shootProjectile(this.entityCreature, to, this.power, this.spread);
                this.lastShot = time;
            } else {
                comeClose = this.comeClose;
            }
        }
        Navigator navigator = this.entityCreature.getNavigator();
        Point pathPosition = navigator.getPathPosition();
        if (!comeClose && distanceSquared <= (double)this.desirableRangeSquared) {
            if (pathPosition != null) {
                navigator.setPathTo(null);
            }
            this.entityCreature.lookAt(target);
            return;
        }
        Pos targetPosition = target.getPosition();
        if ((pathPosition == null || !pathPosition.samePoint((Point)targetPosition)) && this.cooldown.isReady(time)) {
            this.cooldown.refreshLastUpdate(time);
            navigator.setPathTo((Point)targetPosition);
        }
    }

    @Override
    public boolean shouldEnd() {
        return this.stop;
    }

    @Override
    public void end() {
        this.entityCreature.getNavigator().setPathTo(null);
    }

    public static interface ProjectileGenerator {
        public void shootProjectile(EntityCreature var1, Pos var2, double var3, double var5);
    }
}

