/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.GoalSelector;
import org.jetbrains.annotations.NotNull;

public class RandomStrollGoal
extends GoalSelector {
    private static final long DELAY = 2500L;
    private final int radius;
    private final List<Vec> closePositions;
    private final Random random = new Random();
    private long lastStroll;

    public RandomStrollGoal(@NotNull EntityCreature entityCreature, int radius) {
        super(entityCreature);
        this.radius = radius;
        this.closePositions = RandomStrollGoal.getNearbyBlocks(radius);
    }

    @Override
    public boolean shouldStart() {
        return System.currentTimeMillis() - this.lastStroll >= 2500L;
    }

    @Override
    public void start() {
        int remainingAttempt = this.closePositions.size();
        while (remainingAttempt-- > 0) {
            int index = this.random.nextInt(this.closePositions.size());
            Vec position = this.closePositions.get(index);
            Pos target = this.entityCreature.getPosition().add((Point)position);
            boolean result = this.entityCreature.getNavigator().setPathTo((Point)target);
            if (!result) continue;
            break;
        }
    }

    @Override
    public void tick(long time) {
    }

    @Override
    public boolean shouldEnd() {
        return true;
    }

    @Override
    public void end() {
        this.lastStroll = System.currentTimeMillis();
    }

    public int getRadius() {
        return this.radius;
    }

    @NotNull
    private static List<Vec> getNearbyBlocks(int radius) {
        ArrayList<Vec> blocks = new ArrayList<Vec>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    blocks.add(new Vec((double)x, (double)y, (double)z));
                }
            }
        }
        return blocks;
    }
}

