/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.GoalSelector;
import org.jetbrains.annotations.NotNull;

public class RandomLookAroundGoal
extends GoalSelector {
    private static final Random RANDOM = new Random();
    private final int chancePerTick;
    private final Supplier<Integer> minimalLookTimeSupplier;
    private final Function<EntityCreature, Vec> randomDirectionFunction;
    private Vec lookDirection;
    private int lookTime = 0;

    public RandomLookAroundGoal(EntityCreature entityCreature, int chancePerTick) {
        this(entityCreature, chancePerTick, () -> 20 + RANDOM.nextInt(20), creature -> {
            double n = Math.PI * 2 * RANDOM.nextDouble();
            return new Vec((double)((float)Math.cos(n)), 0.0, (double)((float)Math.sin(n)));
        });
    }

    public RandomLookAroundGoal(EntityCreature entityCreature, int chancePerTick, @NotNull Supplier<Integer> minimalLookTimeSupplier, @NotNull Function<EntityCreature, Vec> randomDirectionFunction) {
        super(entityCreature);
        this.chancePerTick = chancePerTick;
        this.minimalLookTimeSupplier = minimalLookTimeSupplier;
        this.randomDirectionFunction = randomDirectionFunction;
    }

    @Override
    public boolean shouldStart() {
        if (RANDOM.nextInt(this.chancePerTick) != 0) {
            return false;
        }
        return this.entityCreature.getNavigator().getPathPosition() == null;
    }

    @Override
    public void start() {
        this.lookTime = this.minimalLookTimeSupplier.get();
        this.lookDirection = this.randomDirectionFunction.apply(this.entityCreature);
    }

    @Override
    public void tick(long time) {
        --this.lookTime;
        this.entityCreature.refreshPosition(this.entityCreature.getPosition().withDirection((Point)this.lookDirection));
    }

    @Override
    public boolean shouldEnd() {
        return this.lookTime < 0;
    }

    @Override
    public void end() {
    }
}

