/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.entity.pathfinding.Navigator;
import net.minestom.server.timer.Cooldown;
import net.minestom.server.timer.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MeleeAttackGoal
extends GoalSelector {
    private final Cooldown cooldown = new Cooldown(Duration.of(5L, TimeUnit.SERVER_TICK));
    private long lastHit;
    private final double range;
    private final Duration delay;
    private boolean stop;
    private Entity cachedTarget;

    public MeleeAttackGoal(@NotNull EntityCreature entityCreature, double range, int delay, @NotNull TemporalUnit timeUnit) {
        this(entityCreature, range, Duration.of(delay, timeUnit));
    }

    public MeleeAttackGoal(@NotNull EntityCreature entityCreature, double range, Duration delay) {
        super(entityCreature);
        this.range = range;
        this.delay = delay;
    }

    @NotNull
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public boolean shouldStart() {
        this.cachedTarget = this.findTarget();
        return this.cachedTarget != null;
    }

    @Override
    public void start() {
        Pos targetPosition = this.cachedTarget.getPosition();
        this.entityCreature.getNavigator().setPathTo((Point)targetPosition);
    }

    @Override
    public void tick(long time) {
        Entity target;
        if (this.cachedTarget != null) {
            target = this.cachedTarget;
            this.cachedTarget = null;
        } else {
            target = this.findTarget();
        }
        boolean bl = this.stop = target == null;
        if (!this.stop) {
            if (this.entityCreature.getDistanceSquared(target) <= this.range * this.range) {
                this.entityCreature.lookAt(target);
                if (!Cooldown.hasCooldown(time, this.lastHit, this.delay)) {
                    this.entityCreature.attack(target, true);
                    this.lastHit = time;
                }
                return;
            }
            Navigator navigator = this.entityCreature.getNavigator();
            Point pathPosition = navigator.getPathPosition();
            Pos targetPosition = target.getPosition();
            if ((pathPosition == null || !pathPosition.samePoint((Point)targetPosition)) && this.cooldown.isReady(time)) {
                this.cooldown.refreshLastUpdate(time);
                navigator.setPathTo((Point)targetPosition);
            }
        }
    }

    @Override
    public boolean shouldEnd() {
        return this.stop;
    }

    @Override
    public void end() {
        this.entityCreature.getNavigator().setPathTo(null);
    }
}

