/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai.goal;

import java.util.Random;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.utils.MathUtils;

public class DoNothingGoal
extends GoalSelector {
    private static final Random RANDOM = new Random();
    private final long time;
    private final float chance;
    private long startTime;

    public DoNothingGoal(EntityCreature entityCreature, long time, float chance) {
        super(entityCreature);
        this.time = time;
        this.chance = MathUtils.clamp((float)chance, (float)0.0f, (float)1.0f);
    }

    @Override
    public void end() {
        this.startTime = 0L;
    }

    @Override
    public boolean shouldEnd() {
        return System.currentTimeMillis() - this.startTime >= this.time;
    }

    @Override
    public boolean shouldStart() {
        return RANDOM.nextFloat() <= this.chance;
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void tick(long time) {
    }
}

