/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minestom.server.entity.ai.GoalSelector;
import net.minestom.server.entity.ai.TargetSelector;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIGroup {
    private GoalSelector currentGoalSelector;
    private final List<GoalSelector> goalSelectors = new GoalSelectorsArrayList();
    private final List<TargetSelector> targetSelectors = new ArrayList<TargetSelector>();

    @NotNull
    public List<GoalSelector> getGoalSelectors() {
        return this.goalSelectors;
    }

    @NotNull
    public List<TargetSelector> getTargetSelectors() {
        return this.targetSelectors;
    }

    @Nullable
    public GoalSelector getCurrentGoalSelector() {
        return this.currentGoalSelector;
    }

    public void setCurrentGoalSelector(@Nullable GoalSelector goalSelector) {
        Check.argCondition((goalSelector != null && goalSelector.getAIGroup() != this ? 1 : 0) != 0, (String)"Tried to set goal selector attached to another AI group!");
        this.currentGoalSelector = goalSelector;
    }

    public void tick(long time) {
        GoalSelector currentGoalSelector = this.getCurrentGoalSelector();
        if (currentGoalSelector != null && currentGoalSelector.shouldEnd()) {
            currentGoalSelector.end();
            currentGoalSelector = null;
            this.setCurrentGoalSelector(null);
        }
        for (GoalSelector selector : this.getGoalSelectors()) {
            if (selector == currentGoalSelector) break;
            if (!selector.shouldStart()) continue;
            if (currentGoalSelector != null) {
                currentGoalSelector.end();
            }
            currentGoalSelector = selector;
            this.setCurrentGoalSelector(currentGoalSelector);
            currentGoalSelector.start();
            break;
        }
        if (currentGoalSelector != null) {
            currentGoalSelector.tick(time);
        }
    }

    private class GoalSelectorsArrayList
    extends ArrayList<GoalSelector> {
        private GoalSelectorsArrayList() {
        }

        @Override
        public GoalSelector set(int index, GoalSelector element) {
            element.setAIGroup(EntityAIGroup.this);
            return super.set(index, element);
        }

        @Override
        public boolean add(GoalSelector element) {
            element.setAIGroup(EntityAIGroup.this);
            return super.add(element);
        }

        @Override
        public void add(int index, GoalSelector element) {
            element.setAIGroup(EntityAIGroup.this);
            super.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends GoalSelector> c) {
            c.forEach((? super T goalSelector) -> goalSelector.setAIGroup(EntityAIGroup.this));
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends GoalSelector> c) {
            c.forEach((? super T goalSelector) -> goalSelector.setAIGroup(EntityAIGroup.this));
            return super.addAll(index, c);
        }

        @Override
        public void replaceAll(UnaryOperator<GoalSelector> operator) {
            super.replaceAll(goalSelector -> {
                goalSelector = (GoalSelector)operator.apply((GoalSelector)goalSelector);
                goalSelector.setAIGroup(EntityAIGroup.this);
                return goalSelector;
            });
        }
    }
}

