/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.network.packet.server.play.EntityMetaDataPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetadataHolder {
    private static final VarHandle NOTIFIED_CHANGES;
    private final Entity entity;
    private volatile Metadata.Entry<?>[] entries = new Metadata.Entry[0];
    private volatile Map<Integer, Metadata.Entry<?>> entryMap = null;
    private volatile boolean notifyAboutChanges = true;
    private final Map<Integer, Metadata.Entry<?>> notNotifiedChanges = new HashMap();

    public MetadataHolder(@Nullable Entity entity) {
        this.entity = entity;
    }

    public <T> T getIndex(int index, @Nullable T defaultValue) {
        Metadata.Entry<?>[] entries = this.entries;
        if (index < 0 || index >= entries.length) {
            return defaultValue;
        }
        Metadata.Entry<?> entry = entries[index];
        return (T)(entry != null ? entry.value() : defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(int index, @NotNull Metadata.Entry<?> entry) {
        Metadata.Entry<?>[] entries = this.entries;
        if (index >= entries.length) {
            int newLength = Math.max(entries.length * 2, index + 1);
            this.entries = entries = Arrays.copyOf(entries, newLength);
        }
        entries[index] = entry;
        this.entryMap = null;
        Entity entity = this.entity;
        if (entity != null && entity.isActive()) {
            if (!this.notifyAboutChanges) {
                Map<Integer, Metadata.Entry<?>> map = this.notNotifiedChanges;
                synchronized (map) {
                    this.notNotifiedChanges.put(index, entry);
                }
            } else {
                entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), Map.of(index, entry)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        Map<Integer, Metadata.Entry<?>> entries;
        if (!NOTIFIED_CHANGES.compareAndSet(this, !notifyAboutChanges, notifyAboutChanges)) {
            return;
        }
        if (!notifyAboutChanges) {
            return;
        }
        Entity entity = this.entity;
        if (entity == null || !entity.isActive()) {
            return;
        }
        Map<Integer, Metadata.Entry<?>> map = this.notNotifiedChanges;
        synchronized (map) {
            Map<Integer, Metadata.Entry<?>> awaitingChanges = this.notNotifiedChanges;
            if (awaitingChanges.isEmpty()) {
                return;
            }
            entries = Map.copyOf(awaitingChanges);
            awaitingChanges.clear();
        }
        entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), entries));
    }

    @NotNull
    public Map<Integer, Metadata.Entry<?>> getEntries() {
        Map<Integer, Metadata.Entry<?>> map = this.entryMap;
        if (map == null) {
            map = new HashMap();
            Metadata.Entry<?>[] entries = this.entries;
            for (int i = 0; i < entries.length; ++i) {
                Metadata.Entry<?> entry = entries[i];
                if (entry == null) continue;
                map.put(i, entry);
            }
            this.entryMap = Map.copyOf(map);
        }
        return map;
    }

    static {
        try {
            NOTIFIED_CHANGES = MethodHandles.lookup().findVarHandle(MetadataHolder.class, "notifyAboutChanges", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

