/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataDef;

final class MetadataDefImpl {
    static final Map<String, Integer> MAX_INDEX = new HashMap<String, Integer>();

    MetadataDefImpl() {
    }

    static <T> MetadataDef.Entry<T> index(int index, Function<T, Metadata.Entry<T>> function, T defaultValue) {
        MetadataDefImpl.storeMaxIndex(index);
        int superIndex = MetadataDefImpl.findSuperIndex();
        return new MetadataDef.Entry.Index<T>(superIndex + index, function, defaultValue);
    }

    static <T> MetadataDef.Entry<Boolean> mask(int index, int bitMask, boolean defaultValue) {
        MetadataDefImpl.storeMaxIndex(index);
        int superIndex = MetadataDefImpl.findSuperIndex();
        return new MetadataDef.Entry.Mask(superIndex + index, bitMask, defaultValue);
    }

    static void storeMaxIndex(int index) {
        String className = Thread.currentThread().getStackTrace()[3].getClassName();
        int currentMax = MAX_INDEX.getOrDefault(className, 0);
        MAX_INDEX.put(className, Math.max(currentMax, index));
    }

    static int findSuperIndex() {
        try {
            String className = Thread.currentThread().getStackTrace()[3].getClassName();
            Class<?> subclass = Class.forName(className);
            Class<?> superclass = subclass.getSuperclass();
            if (superclass == Object.class) {
                return 0;
            }
            int index = 0;
            do {
                index += MAX_INDEX.get(superclass.getName()) + 1;
            } while ((superclass = superclass.getSuperclass()) != Object.class);
            return index;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

