/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Collection;
import net.minestom.server.entity.EntityTypeImpl;
import net.minestom.server.entity.EntityTypes;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface EntityType
extends StaticProtocolObject,
EntityTypes
permits EntityTypeImpl {
    @Contract(pure=true)
    @NotNull
    public Registry.EntityEntry registry();

    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    default public int id() {
        return this.registry().id();
    }

    default public double width() {
        return this.registry().width();
    }

    default public double height() {
        return this.registry().height();
    }

    @NotNull
    public static @NotNull Collection<@NotNull EntityType> values() {
        return EntityTypeImpl.values();
    }

    public static EntityType fromNamespaceId(@NotNull String namespaceID) {
        return EntityTypeImpl.getSafe(namespaceID);
    }

    public static EntityType fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return EntityType.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static EntityType fromId(int id) {
        return EntityTypeImpl.getId(id);
    }
}

