/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record DataComponentMapImpl(@NotNull Int2ObjectMap<Object> components) implements DataComponentMap
{
    private static final char REMOVAL_PREFIX = '!';

    @Override
    public boolean has(@NotNull DataComponent<?> component) {
        return this.components.containsKey(component.id()) && this.components.get(component.id()) != null;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull DataComponent<T> component) {
        return (T)this.components.get(component.id());
    }

    @Override
    public boolean has(@NotNull DataComponentMap prototype, @NotNull DataComponent<?> component) {
        if (this.components.containsKey(component.id())) {
            return this.components.get(component.id()) != null;
        }
        return prototype.has(component);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull DataComponentMap prototype, @NotNull DataComponent<T> component) {
        if (this.components.containsKey(component.id())) {
            return (T)this.components.get(component.id());
        }
        return prototype.get(component);
    }

    @Override
    @NotNull
    public <T> DataComponentMap set(@NotNull DataComponent<T> component, @NotNull T value) {
        Int2ObjectArrayMap newComponents = new Int2ObjectArrayMap(this.components);
        newComponents.put(component.id(), value);
        return new DataComponentMapImpl((Int2ObjectMap<Object>)newComponents);
    }

    @Override
    @NotNull
    public DataComponentMap remove(@NotNull DataComponent<?> component) {
        Int2ObjectArrayMap newComponents = new Int2ObjectArrayMap(this.components);
        newComponents.put(component.id(), null);
        return new DataComponentMapImpl((Int2ObjectMap<Object>)newComponents);
    }

    @Override
    @NotNull
    public DataComponentMap.Builder toBuilder() {
        return new BuilderImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
    }

    @Override
    @NotNull
    public DataComponentMap.PatchBuilder toPatchBuilder() {
        return new PatchBuilderImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
    }

    record BuilderImpl(@NotNull Int2ObjectMap<Object> components) implements DataComponentMap.Builder
    {
        @Override
        public boolean has(@NotNull DataComponent<?> component) {
            return this.components.get(component.id()) != null;
        }

        @Override
        @Nullable
        public <T> T get(@NotNull DataComponent<T> component) {
            return (T)this.components.get(component.id());
        }

        @Override
        @NotNull
        public <T> DataComponentMap.Builder set(@NotNull DataComponent<T> component, @NotNull T value) {
            this.components.put(component.id(), value);
            return this;
        }

        @Override
        @NotNull
        public DataComponentMap build() {
            return new DataComponentMapImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
        }
    }

    record PatchBuilderImpl(@NotNull Int2ObjectMap<Object> components) implements DataComponentMap.PatchBuilder
    {
        @Override
        public boolean has(@NotNull DataComponent<?> component) {
            return this.components.get(component.id()) != null;
        }

        @Override
        @Nullable
        public <T> T get(@NotNull DataComponent<T> component) {
            return (T)this.components.get(component.id());
        }

        @Override
        @NotNull
        public <T> DataComponentMap.PatchBuilder set(@NotNull DataComponent<T> component, @NotNull T value) {
            this.components.put(component.id(), value);
            return this;
        }

        @Override
        @NotNull
        public DataComponentMap.PatchBuilder remove(@NotNull DataComponent<?> component) {
            this.components.put(component.id(), null);
            return this;
        }

        @Override
        @NotNull
        public DataComponentMap build() {
            return new DataComponentMapImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(this.components));
        }
    }

    record NbtType(@NotNull IntFunction<DataComponent<?>> idToType, @NotNull Function<String, DataComponent<?>> nameToType, boolean isPatch) implements BinaryTagSerializer<DataComponentMap>
    {
        @Override
        @NotNull
        public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull DataComponentMap value) {
            DataComponentMapImpl patch = (DataComponentMapImpl)value;
            if (patch.components.isEmpty()) {
                return CompoundBinaryTag.empty();
            }
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            for (Int2ObjectMap.Entry entry : patch.components.int2ObjectEntrySet()) {
                DataComponent<?> type = this.idToType.apply(entry.getIntKey());
                Check.notNull(type, (String)"Unknown item component id: {0}", (Object[])new Object[]{entry.getIntKey()});
                if (entry.getValue() == null) {
                    if (!this.isPatch) continue;
                    builder.put("!" + type.name(), (BinaryTag)CompoundBinaryTag.empty());
                    continue;
                }
                builder.put(type.name(), type.write(context, entry.getValue()));
            }
            return builder.build();
        }

        @Override
        @NotNull
        public DataComponentMap read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag anyTag) {
            if (!(anyTag instanceof CompoundBinaryTag)) {
                throw new IllegalArgumentException("Component patch must be a compound tag, was: " + String.valueOf(anyTag.type()));
            }
            CompoundBinaryTag tag = (CompoundBinaryTag)anyTag;
            if (tag.size() == 0) {
                return DataComponentMap.EMPTY;
            }
            Int2ObjectArrayMap patch = new Int2ObjectArrayMap(tag.size());
            for (Map.Entry entry : tag) {
                String key = (String)entry.getKey();
                boolean remove = false;
                if (!key.isEmpty() && key.charAt(0) == '!') {
                    key = key.substring(1);
                    remove = true;
                }
                DataComponent<?> type = this.nameToType.apply(key);
                Check.notNull(type, (String)"Unknown item component: {0}", (Object[])new Object[]{key});
                if (remove) {
                    if (!this.isPatch) continue;
                    patch.put(type.id(), null);
                    continue;
                }
                Object value = type.read(context, (BinaryTag)entry.getValue());
                patch.put(type.id(), value);
            }
            return new DataComponentMapImpl((Int2ObjectMap<Object>)patch);
        }
    }

    record PatchNetworkType(@NotNull IntFunction<DataComponent<?>> idToType) implements NetworkBuffer.Type<DataComponentMap>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, DataComponentMap value) {
            DataComponentMapImpl patch = (DataComponentMapImpl)value;
            int added = 0;
            for (Object o : patch.components.values()) {
                if (o == null) continue;
                ++added;
            }
            buffer.write(NetworkBuffer.VAR_INT, added);
            buffer.write(NetworkBuffer.VAR_INT, patch.components.size() - added);
            for (Int2ObjectMap.Entry entry : patch.components.int2ObjectEntrySet()) {
                if (entry.getValue() == null) continue;
                buffer.write(NetworkBuffer.VAR_INT, entry.getIntKey());
                DataComponent<?> type = this.idToType.apply(entry.getIntKey());
                assert (type != null);
                type.write(buffer, entry.getValue());
            }
            for (Int2ObjectMap.Entry entry : patch.components.int2ObjectEntrySet()) {
                if (entry.getValue() != null) continue;
                buffer.write(NetworkBuffer.VAR_INT, entry.getIntKey());
            }
        }

        @Override
        public DataComponentMap read(@NotNull NetworkBuffer buffer) {
            int id;
            int i;
            int removed;
            int added = buffer.read(NetworkBuffer.VAR_INT);
            Check.stateCondition((added + (removed = buffer.read(NetworkBuffer.VAR_INT).intValue()) > 256 ? 1 : 0) != 0, (String)"Item component patch too large: {0}", (Object[])new Object[]{added + removed});
            Int2ObjectArrayMap patch = new Int2ObjectArrayMap(added + removed);
            for (i = 0; i < added; ++i) {
                id = buffer.read(NetworkBuffer.VAR_INT);
                DataComponent<?> type = this.idToType.apply(id);
                Check.notNull(type, (String)"Unknown component: {0}", (Object[])new Object[]{id});
                patch.put(type.id(), type.read(buffer));
            }
            for (i = 0; i < removed; ++i) {
                id = buffer.read(NetworkBuffer.VAR_INT);
                patch.put(id, null);
            }
            return new DataComponentMapImpl((Int2ObjectMap<Object>)patch);
        }
    }
}

