/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.component.DataComponent;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record DataComponentImpl<T>(int id, @NotNull NamespaceID namespace, @Nullable NetworkBuffer.Type<T> network, @Nullable BinaryTagSerializer<T> nbt) implements DataComponent<T>
{
    @Override
    public boolean isSynced() {
        return this.network != null;
    }

    @Override
    public boolean isSerialized() {
        return this.nbt != null;
    }

    @Override
    @NotNull
    public T read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag tag) {
        Check.notNull(this.nbt, (String)"{0} cannot be deserialized from NBT", (Object[])new Object[]{this});
        return this.nbt.read(context, tag);
    }

    @Override
    @NotNull
    public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull T value) {
        Check.notNull(this.nbt, (String)"{0} cannot be serialized to NBT", (Object[])new Object[]{this});
        return this.nbt.write(context, value);
    }

    @Override
    @NotNull
    public T read(@NotNull NetworkBuffer reader) {
        Check.notNull(this.network, (String)"{0} cannot be deserialized from network", (Object[])new Object[]{this});
        return this.network.read(reader);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer, @NotNull T value) {
        Check.notNull(this.network, (String)"{0} cannot be serialized to network", (Object[])new Object[]{this});
        this.network.write(writer, value);
    }

    @Override
    public String toString() {
        return this.name();
    }
}

