/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.relative;

import java.util.Set;
import java.util.function.Function;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.coordinate.RelativeVec;
import net.minestom.server.coordinate.Vec;
import org.jetbrains.annotations.NotNull;

abstract class ArgumentRelativeVec
extends Argument<RelativeVec> {
    private static final char RELATIVE_CHAR = '~';
    private static final char LOCAL_CHAR = '^';
    private static final Set<Character> MODIFIER_CHARS = Set.of(Character.valueOf('~'), Character.valueOf('^'));
    public static final int INVALID_NUMBER_COUNT_ERROR = 1;
    public static final int INVALID_NUMBER_ERROR = 2;
    public static final int MIXED_TYPE_ERROR = 3;
    private final int numberCount;

    public ArgumentRelativeVec(@NotNull String id, int numberCount) {
        super(id, true);
        this.numberCount = numberCount;
    }

    abstract Function<String, ? extends Number> getRelativeNumberParser();

    abstract Function<String, ? extends Number> getAbsoluteNumberParser();

    @Override
    @NotNull
    public RelativeVec parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        String[] split = input.split(" ");
        if (split.length != this.getNumberCount()) {
            throw new ArgumentSyntaxException("Invalid number of values", input, 1);
        }
        double[] coordinates = new double[split.length];
        boolean[] isRelative = new boolean[split.length];
        RelativeVec.CoordinateType type = null;
        for (int i = 0; i < split.length; ++i) {
            String element = split[i];
            try {
                char modifierChar = element.charAt(0);
                if (MODIFIER_CHARS.contains(Character.valueOf(modifierChar))) {
                    isRelative[i] = true;
                    if (type == null) {
                        type = modifierChar == '^' ? RelativeVec.CoordinateType.LOCAL : RelativeVec.CoordinateType.RELATIVE;
                    } else if (type == RelativeVec.CoordinateType.LOCAL != (modifierChar == '^')) {
                        throw new ArgumentSyntaxException("Cannot mix world & local coordinates (everything must either use ^ or not)", input, 3);
                    }
                    if (element.length() <= 1) continue;
                    String potentialNumber = element.substring(1);
                    coordinates[i] = this.getRelativeNumberParser().apply(potentialNumber).doubleValue();
                    continue;
                }
                if (type == null) {
                    type = RelativeVec.CoordinateType.ABSOLUTE;
                } else if (type == RelativeVec.CoordinateType.LOCAL) {
                    throw new ArgumentSyntaxException("Cannot mix world & local coordinates (everything must either use ^ or not)", input, 3);
                }
                coordinates[i] = this.getAbsoluteNumberParser().apply(element).doubleValue();
                continue;
            }
            catch (NumberFormatException e) {
                throw new ArgumentSyntaxException("Invalid number", input, 2);
            }
        }
        return new RelativeVec(split.length == 3 ? new Vec(coordinates[0], coordinates[1], coordinates[2]) : new Vec(coordinates[0], coordinates[1]), type, isRelative[0], split.length == 3 && isRelative[1], isRelative[split.length == 3 ? 2 : 1]);
    }

    public int getNumberCount() {
        return this.numberCount;
    }
}

