/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.timer.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentTime
extends Argument<Duration> {
    public static final int INVALID_TIME_FORMAT = -2;
    public static final int NO_NUMBER = -3;
    private static final CharList SUFFIXES = new CharArrayList(new char[]{'d', 's', 't'});
    private int min = 0;

    public ArgumentTime(String id) {
        super(id);
    }

    @NotNull
    public ArgumentTime min(int min) {
        this.min = min;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Duration parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        TemporalUnit timeUnit;
        char lastChar = input.charAt(input.length() - 1);
        if (Character.isDigit(lastChar)) {
            timeUnit = TimeUnit.SERVER_TICK;
        } else {
            if (!SUFFIXES.contains(lastChar)) throw new ArgumentSyntaxException("Time needs to have a unit", input, -3);
            input = input.substring(0, input.length() - 1);
            if (lastChar == 'd') {
                timeUnit = TimeUnit.DAY;
            } else if (lastChar == 's') {
                timeUnit = TimeUnit.SECOND;
            } else {
                if (lastChar != 't') throw new ArgumentSyntaxException("Time needs to have the unit d, s, t, or none", input, -3);
                timeUnit = TimeUnit.SERVER_TICK;
            }
        }
        try {
            int time = Integer.parseInt(input);
            return Duration.of(time, timeUnit);
        }
        catch (NumberFormatException e) {
            throw new ArgumentSyntaxException("Time needs to be a number", input, -3);
        }
    }

    @Override
    public byte @Nullable [] nodeProperties() {
        return NetworkBuffer.makeArray(buffer -> buffer.write(NetworkBuffer.INT, this.min));
    }

    @Override
    public String parser() {
        return "minecraft:time";
    }

    public String toString() {
        return String.format("Time<%s>", this.getId());
    }
}

