/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.IOException;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;

public class ArgumentNbtTag
extends Argument<BinaryTag> {
    public static final int INVALID_NBT = 1;

    public ArgumentNbtTag(String id) {
        super(id, true);
    }

    @Override
    @NotNull
    public BinaryTag parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        try {
            return TagStringIOExt.readTag((String)input);
        }
        catch (IOException e) {
            throw new ArgumentSyntaxException("Invalid NBT", input, 1);
        }
    }

    @Override
    public String parser() {
        return "minecraft:nbt_tag";
    }

    public String toString() {
        return String.format("NBT<%s>", this.getId());
    }
}

