/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minestom.server.entity.Entity;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.Acquired;
import net.minestom.server.thread.TickThread;
import net.minestom.server.utils.async.AsyncUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public sealed interface Acquirable<T>
permits AcquirableImpl {
    @NotNull
    public static @NotNull Stream<@NotNull Entity> currentEntities() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof TickThread) {
            return ((TickThread)currentThread).entries().stream().flatMap(partitionEntry -> partitionEntry.elements().stream()).filter(tickable -> tickable instanceof Entity).map(tickable -> (Entity)tickable);
        }
        return Stream.empty();
    }

    @ApiStatus.Internal
    public static long resetAcquiringTime() {
        return AcquirableImpl.WAIT_COUNTER_NANO.getAndSet(0L);
    }

    @ApiStatus.Internal
    @NotNull
    public static <T> Acquirable<T> of(@NotNull T value) {
        return new AcquirableImpl<T>(value);
    }

    @NotNull
    default public Acquired<T> lock() {
        return new Acquired<T>(this.unwrap(), this.assignedThread());
    }

    @NotNull
    default public Optional<T> local() {
        if (this.isLocal()) {
            return Optional.of(this.unwrap());
        }
        return Optional.empty();
    }

    default public boolean isLocal() {
        return Thread.currentThread() == this.assignedThread();
    }

    default public void sync(@NotNull Consumer<T> consumer) {
        Acquired<T> acquired = this.lock();
        try {
            consumer.accept(acquired.get());
        }
        finally {
            acquired.unlock();
        }
    }

    default public void async(@NotNull Consumer<T> consumer) {
        AsyncUtils.runAsync(() -> this.sync(consumer));
    }

    @NotNull
    public T unwrap();

    @ApiStatus.Internal
    @NotNull
    public TickThread assignedThread();
}

