/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import net.minestom.server.ServerFlag;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.network.packet.server.play.InitializeWorldBorderPacket;
import net.minestom.server.network.packet.server.play.WorldBorderCenterPacket;
import net.minestom.server.network.packet.server.play.WorldBorderLerpSizePacket;
import net.minestom.server.network.packet.server.play.WorldBorderSizePacket;
import net.minestom.server.network.packet.server.play.WorldBorderWarningDelayPacket;
import net.minestom.server.network.packet.server.play.WorldBorderWarningReachPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record WorldBorder(double diameter, double centerX, double centerZ, int warningDistance, int warningTime, int dimensionTeleportBoundary) {
    public static final WorldBorder DEFAULT_BORDER = new WorldBorder(ServerFlag.WORLD_BORDER_SIZE * 2, 0.0, 0.0, 5, 15, ServerFlag.WORLD_BORDER_SIZE);

    public WorldBorder {
        Check.argCondition(diameter < 0.0, "Diameter should be >= 0");
    }

    public WorldBorder(double diameter, double centerX, double centerZ, int warningDistance, int warningTime) {
        this(diameter, centerX, centerZ, warningDistance, warningTime, ServerFlag.WORLD_BORDER_SIZE);
    }

    @Contract(pure=true)
    @NotNull
    public WorldBorder withDiameter(double diameter) {
        return new WorldBorder(diameter, this.centerX, this.centerZ, this.warningDistance, this.warningTime, this.dimensionTeleportBoundary);
    }

    @Contract(pure=true)
    @NotNull
    public WorldBorder withCenter(double centerX, double centerZ) {
        return new WorldBorder(this.diameter, centerX, centerZ, this.warningDistance, this.warningTime, this.dimensionTeleportBoundary);
    }

    @Contract(pure=true)
    @NotNull
    public WorldBorder withWarningDistance(int warningDistance) {
        return new WorldBorder(this.diameter, this.centerX, this.centerZ, warningDistance, this.warningTime, this.dimensionTeleportBoundary);
    }

    @Contract(pure=true)
    @NotNull
    public WorldBorder withWarningTime(int warningTime) {
        return new WorldBorder(this.diameter, this.centerX, this.centerZ, this.warningDistance, warningTime, this.dimensionTeleportBoundary);
    }

    public boolean inBounds(@NotNull Point point) {
        double radius = this.diameter / 2.0;
        return point.x() <= this.centerX + radius && point.x() >= this.centerX - radius && point.z() <= this.centerZ + radius && point.z() >= this.centerZ - radius;
    }

    public boolean inBounds(@NotNull Entity entity) {
        return this.inBounds(entity.getPosition());
    }

    @NotNull
    public InitializeWorldBorderPacket createInitializePacket(double targetDiameter, long transitionTime) {
        return new InitializeWorldBorderPacket(this.centerX, this.centerZ, this.diameter, targetDiameter, transitionTime, this.dimensionTeleportBoundary, this.warningTime, this.warningDistance);
    }

    @NotNull
    public WorldBorderCenterPacket createCenterPacket() {
        return new WorldBorderCenterPacket(this.centerX, this.centerZ);
    }

    @NotNull
    public WorldBorderLerpSizePacket createLerpSizePacket(double targetDiameter, long transitionTime) {
        return new WorldBorderLerpSizePacket(this.diameter, targetDiameter, transitionTime);
    }

    @NotNull
    public WorldBorderSizePacket createSizePacket() {
        return new WorldBorderSizePacket(this.diameter);
    }

    @NotNull
    public WorldBorderWarningDelayPacket createWarningDelayPacket() {
        return new WorldBorderWarningDelayPacket(this.warningTime);
    }

    @NotNull
    public WorldBorderWarningReachPacket createWarningReachPacket() {
        return new WorldBorderWarningReachPacket(this.warningDistance);
    }
}

