/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.crypto;

import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.crypto.KeyUtils;
import org.jetbrains.annotations.NotNull;

public record PlayerPublicKey(Instant expiresAt, PublicKey publicKey, byte[] signature) implements NetworkBuffer.Writer
{
    public PlayerPublicKey(@NotNull NetworkBuffer reader) {
        this(Instant.ofEpochMilli(reader.read(NetworkBuffer.LONG)), KeyUtils.publicRSAKeyFrom(reader.read(NetworkBuffer.BYTE_ARRAY)), reader.read(NetworkBuffer.BYTE_ARRAY));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.LONG, this.expiresAt().toEpochMilli());
        writer.write(NetworkBuffer.BYTE_ARRAY, this.publicKey.getEncoded());
        writer.write(NetworkBuffer.BYTE_ARRAY, this.signature());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PlayerPublicKey) {
            PlayerPublicKey ppk = (PlayerPublicKey)obj;
            return this.expiresAt.equals(ppk.expiresAt) && this.publicKey.equals(ppk.publicKey) && Arrays.equals(this.signature, ppk.signature);
        }
        return false;
    }
}

