package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

import static net.minestom.server.network.NetworkBuffer.*;

public record OpenHorseWindowPacket(byte windowId, int slotCount, int entityId) implements ServerPacket.Play {
    public OpenHorseWindowPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(BYTE), reader.read(VAR_INT), reader.read(INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(BYTE, windowId);
        writer.write(VAR_INT, slotCount);
        writer.write(INT, entityId);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.OPEN_HORSE_WINDOW;
    }
}
