/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Arrays;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public final class Section
implements NetworkBuffer.Writer {
    private final Palette blockPalette;
    private final Palette biomePalette;
    private final Light skyLight;
    private final Light blockLight;

    private Section(Palette blockPalette, Palette biomePalette) {
        this.blockPalette = blockPalette;
        this.biomePalette = biomePalette;
        this.skyLight = Light.sky(blockPalette);
        this.blockLight = Light.block(blockPalette);
    }

    private Section(Palette blockPalette, Palette biomePalette, Light skyLight, Light blockLight) {
        this.blockPalette = blockPalette;
        this.biomePalette = biomePalette;
        this.skyLight = skyLight;
        this.blockLight = blockLight;
    }

    public Section() {
        this(Palette.blocks(), Palette.biomes());
    }

    public Palette blockPalette() {
        return this.blockPalette;
    }

    public Palette biomePalette() {
        return this.biomePalette;
    }

    public void clear() {
        this.blockPalette.fill(0);
        this.biomePalette.fill(0);
    }

    @NotNull
    public Section clone() {
        Light skyLight = Light.sky(this.blockPalette);
        Light blockLight = Light.block(this.blockPalette);
        this.setSkyLight(this.skyLight.array());
        this.setBlockLight(this.blockLight.array());
        return new Section(this.blockPalette.clone(), this.biomePalette.clone(), skyLight, blockLight);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.SHORT, (short)this.blockPalette.count());
        writer.write(this.blockPalette);
        writer.write(this.biomePalette);
    }

    public void setSkyLight(byte[] copyArray) {
        if (copyArray == null || copyArray.length == 0) {
            this.skyLight.set(LightCompute.emptyContent);
        } else if (Arrays.equals(copyArray, LightCompute.emptyContent)) {
            this.skyLight.set(LightCompute.emptyContent);
        } else if (Arrays.equals(copyArray, LightCompute.contentFullyLit)) {
            this.skyLight.set(LightCompute.contentFullyLit);
        } else {
            this.skyLight.set(copyArray);
        }
    }

    public void setBlockLight(byte[] copyArray) {
        if (copyArray == null || copyArray.length == 0) {
            this.blockLight.set(LightCompute.emptyContent);
        } else if (Arrays.equals(copyArray, LightCompute.emptyContent)) {
            this.blockLight.set(LightCompute.emptyContent);
        } else if (Arrays.equals(copyArray, LightCompute.contentFullyLit)) {
            this.blockLight.set(LightCompute.contentFullyLit);
        } else {
            this.blockLight.set(copyArray);
        }
    }

    public Light skyLight() {
        return this.skyLight;
    }

    public Light blockLight() {
        return this.blockLight;
    }
}

