/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.Set;
import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.PlayerEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncPlayerConfigurationEvent
implements PlayerEvent {
    private final Player player;
    private final boolean isFirstConfig;
    private final ObjectArraySet<NamespaceID> featureFlags = new ObjectArraySet();
    private boolean hardcore;
    private boolean clearChat;
    private boolean sendRegistryData;
    private Instance spawningInstance;

    public AsyncPlayerConfigurationEvent(@NotNull Player player, boolean isFirstConfig) {
        this.player = player;
        this.isFirstConfig = isFirstConfig;
        this.featureFlags.add((Object)NamespaceID.from("minecraft:vanilla"));
        this.hardcore = false;
        this.clearChat = false;
        this.sendRegistryData = isFirstConfig;
        this.spawningInstance = null;
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public boolean isFirstConfig() {
        return this.isFirstConfig;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public void addFeatureFlag(@NotNull NamespaceID feature) {
        this.featureFlags.add((Object)feature);
    }

    public boolean removeFeatureFlag(@NotNull NamespaceID feature) {
        return this.featureFlags.remove((Object)feature);
    }

    @NotNull
    public Set<NamespaceID> getFeatureFlags() {
        return ObjectSets.unmodifiable(this.featureFlags);
    }

    public boolean willClearChat() {
        return this.clearChat;
    }

    public void setClearChat(boolean clearChat) {
        this.clearChat = clearChat;
    }

    public boolean willSendRegistryData() {
        return this.sendRegistryData;
    }

    public void setSendRegistryData(boolean sendRegistryData) {
        this.sendRegistryData = sendRegistryData;
    }

    @Nullable
    public Instance getSpawningInstance() {
        return this.spawningInstance;
    }

    public void setSpawningInstance(@Nullable Instance spawningInstance) {
        this.spawningInstance = spawningInstance;
    }
}

