/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.common.ClientCookieResponsePacket;
import net.minestom.server.network.packet.client.common.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.common.ClientPingRequestPacket;
import net.minestom.server.network.packet.client.common.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.common.ClientResourcePackStatusPacket;
import net.minestom.server.network.packet.client.common.ClientSettingsPacket;
import net.minestom.server.network.packet.client.configuration.ClientFinishConfigurationPacket;
import net.minestom.server.network.packet.client.configuration.ClientSelectKnownPacksPacket;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.client.play.ClientAdvancementTabPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientChangeDifficultyPacket;
import net.minestom.server.network.packet.client.play.ClientChatAckPacket;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientChatSessionUpdatePacket;
import net.minestom.server.network.packet.client.play.ClientChunkBatchReceivedPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowButtonPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientConfigurationAckPacket;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.network.packet.client.play.ClientDebugSampleSubscriptionPacket;
import net.minestom.server.network.packet.client.play.ClientEditBookPacket;
import net.minestom.server.network.packet.client.play.ClientEntityActionPacket;
import net.minestom.server.network.packet.client.play.ClientGenerateStructurePacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInputPacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientLockDifficultyPacket;
import net.minestom.server.network.packet.client.play.ClientNameItemPacket;
import net.minestom.server.network.packet.client.play.ClientPickItemFromBlockPacket;
import net.minestom.server.network.packet.client.play.ClientPickItemFromEntityPacket;
import net.minestom.server.network.packet.client.play.ClientPlaceRecipePacket;
import net.minestom.server.network.packet.client.play.ClientPlayerAbilitiesPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerBlockPlacementPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerLoadedPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionStatusPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientQueryBlockNbtPacket;
import net.minestom.server.network.packet.client.play.ClientQueryEntityNbtPacket;
import net.minestom.server.network.packet.client.play.ClientRecipeBookSeenRecipePacket;
import net.minestom.server.network.packet.client.play.ClientSelectBundleItemPacket;
import net.minestom.server.network.packet.client.play.ClientSelectTradePacket;
import net.minestom.server.network.packet.client.play.ClientSetBeaconEffectPacket;
import net.minestom.server.network.packet.client.play.ClientSetRecipeBookStatePacket;
import net.minestom.server.network.packet.client.play.ClientSignedCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientSpectatePacket;
import net.minestom.server.network.packet.client.play.ClientStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSteerBoatPacket;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientTickEndPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockMinecartPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateCommandBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateJigsawBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateSignPacket;
import net.minestom.server.network.packet.client.play.ClientUpdateStructureBlockPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.client.play.ClientVehicleMovePacket;
import net.minestom.server.network.packet.client.play.ClientWindowSlotStatePacket;
import net.minestom.server.network.packet.client.status.StatusRequestPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.common.CookieRequestPacket;
import net.minestom.server.network.packet.server.common.CookieStorePacket;
import net.minestom.server.network.packet.server.common.CustomReportDetailsPacket;
import net.minestom.server.network.packet.server.common.DisconnectPacket;
import net.minestom.server.network.packet.server.common.KeepAlivePacket;
import net.minestom.server.network.packet.server.common.PingPacket;
import net.minestom.server.network.packet.server.common.PingResponsePacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.common.ResourcePackPopPacket;
import net.minestom.server.network.packet.server.common.ResourcePackPushPacket;
import net.minestom.server.network.packet.server.common.ServerLinksPacket;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.network.packet.server.common.TransferPacket;
import net.minestom.server.network.packet.server.configuration.FinishConfigurationPacket;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.network.packet.server.configuration.ResetChatPacket;
import net.minestom.server.network.packet.server.configuration.SelectKnownPacksPacket;
import net.minestom.server.network.packet.server.configuration.UpdateEnabledFeaturesPacket;
import net.minestom.server.network.packet.server.login.EncryptionRequestPacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.packet.server.login.LoginPluginRequestPacket;
import net.minestom.server.network.packet.server.login.LoginSuccessPacket;
import net.minestom.server.network.packet.server.login.SetCompressionPacket;
import net.minestom.server.network.packet.server.play.AcknowledgeBlockChangePacket;
import net.minestom.server.network.packet.server.play.ActionBarPacket;
import net.minestom.server.network.packet.server.play.AdvancementsPacket;
import net.minestom.server.network.packet.server.play.AttachEntityPacket;
import net.minestom.server.network.packet.server.play.BlockActionPacket;
import net.minestom.server.network.packet.server.play.BlockBreakAnimationPacket;
import net.minestom.server.network.packet.server.play.BlockChangePacket;
import net.minestom.server.network.packet.server.play.BlockEntityDataPacket;
import net.minestom.server.network.packet.server.play.BossBarPacket;
import net.minestom.server.network.packet.server.play.BundlePacket;
import net.minestom.server.network.packet.server.play.CameraPacket;
import net.minestom.server.network.packet.server.play.ChangeGameStatePacket;
import net.minestom.server.network.packet.server.play.ChunkBatchFinishedPacket;
import net.minestom.server.network.packet.server.play.ChunkBatchStartPacket;
import net.minestom.server.network.packet.server.play.ChunkBiomesPacket;
import net.minestom.server.network.packet.server.play.ChunkDataPacket;
import net.minestom.server.network.packet.server.play.ClearTitlesPacket;
import net.minestom.server.network.packet.server.play.CloseWindowPacket;
import net.minestom.server.network.packet.server.play.CollectItemPacket;
import net.minestom.server.network.packet.server.play.CustomChatCompletionPacket;
import net.minestom.server.network.packet.server.play.DamageEventPacket;
import net.minestom.server.network.packet.server.play.DeathCombatEventPacket;
import net.minestom.server.network.packet.server.play.DebugSamplePacket;
import net.minestom.server.network.packet.server.play.DeclareCommandsPacket;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.network.packet.server.play.DeleteChatPacket;
import net.minestom.server.network.packet.server.play.DestroyEntitiesPacket;
import net.minestom.server.network.packet.server.play.DisguisedChatPacket;
import net.minestom.server.network.packet.server.play.DisplayScoreboardPacket;
import net.minestom.server.network.packet.server.play.EndCombatEventPacket;
import net.minestom.server.network.packet.server.play.EnterCombatEventPacket;
import net.minestom.server.network.packet.server.play.EntityAnimationPacket;
import net.minestom.server.network.packet.server.play.EntityAttributesPacket;
import net.minestom.server.network.packet.server.play.EntityEffectPacket;
import net.minestom.server.network.packet.server.play.EntityEquipmentPacket;
import net.minestom.server.network.packet.server.play.EntityHeadLookPacket;
import net.minestom.server.network.packet.server.play.EntityMetaDataPacket;
import net.minestom.server.network.packet.server.play.EntityPositionAndRotationPacket;
import net.minestom.server.network.packet.server.play.EntityPositionPacket;
import net.minestom.server.network.packet.server.play.EntityPositionSyncPacket;
import net.minestom.server.network.packet.server.play.EntityRotationPacket;
import net.minestom.server.network.packet.server.play.EntitySoundEffectPacket;
import net.minestom.server.network.packet.server.play.EntityStatusPacket;
import net.minestom.server.network.packet.server.play.EntityTeleportPacket;
import net.minestom.server.network.packet.server.play.EntityVelocityPacket;
import net.minestom.server.network.packet.server.play.ExplosionPacket;
import net.minestom.server.network.packet.server.play.FacePlayerPacket;
import net.minestom.server.network.packet.server.play.HeldItemChangePacket;
import net.minestom.server.network.packet.server.play.HitAnimationPacket;
import net.minestom.server.network.packet.server.play.InitializeWorldBorderPacket;
import net.minestom.server.network.packet.server.play.JoinGamePacket;
import net.minestom.server.network.packet.server.play.MapDataPacket;
import net.minestom.server.network.packet.server.play.MoveMinecartPacket;
import net.minestom.server.network.packet.server.play.MultiBlockChangePacket;
import net.minestom.server.network.packet.server.play.NbtQueryResponsePacket;
import net.minestom.server.network.packet.server.play.OpenBookPacket;
import net.minestom.server.network.packet.server.play.OpenHorseWindowPacket;
import net.minestom.server.network.packet.server.play.OpenSignEditorPacket;
import net.minestom.server.network.packet.server.play.OpenWindowPacket;
import net.minestom.server.network.packet.server.play.ParticlePacket;
import net.minestom.server.network.packet.server.play.PlaceGhostRecipePacket;
import net.minestom.server.network.packet.server.play.PlayerAbilitiesPacket;
import net.minestom.server.network.packet.server.play.PlayerChatMessagePacket;
import net.minestom.server.network.packet.server.play.PlayerInfoRemovePacket;
import net.minestom.server.network.packet.server.play.PlayerInfoUpdatePacket;
import net.minestom.server.network.packet.server.play.PlayerListHeaderAndFooterPacket;
import net.minestom.server.network.packet.server.play.PlayerPositionAndLookPacket;
import net.minestom.server.network.packet.server.play.PlayerRotationPacket;
import net.minestom.server.network.packet.server.play.ProjectilePowerPacket;
import net.minestom.server.network.packet.server.play.RecipeBookAddPacket;
import net.minestom.server.network.packet.server.play.RecipeBookRemovePacket;
import net.minestom.server.network.packet.server.play.RecipeBookSettingsPacket;
import net.minestom.server.network.packet.server.play.RemoveEntityEffectPacket;
import net.minestom.server.network.packet.server.play.ResetScorePacket;
import net.minestom.server.network.packet.server.play.RespawnPacket;
import net.minestom.server.network.packet.server.play.ScoreboardObjectivePacket;
import net.minestom.server.network.packet.server.play.SelectAdvancementTabPacket;
import net.minestom.server.network.packet.server.play.ServerDataPacket;
import net.minestom.server.network.packet.server.play.ServerDifficultyPacket;
import net.minestom.server.network.packet.server.play.SetCooldownPacket;
import net.minestom.server.network.packet.server.play.SetCursorItemPacket;
import net.minestom.server.network.packet.server.play.SetExperiencePacket;
import net.minestom.server.network.packet.server.play.SetPassengersPacket;
import net.minestom.server.network.packet.server.play.SetPlayerInventorySlotPacket;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.SetTickStatePacket;
import net.minestom.server.network.packet.server.play.SetTitleSubTitlePacket;
import net.minestom.server.network.packet.server.play.SetTitleTextPacket;
import net.minestom.server.network.packet.server.play.SetTitleTimePacket;
import net.minestom.server.network.packet.server.play.SoundEffectPacket;
import net.minestom.server.network.packet.server.play.SpawnEntityPacket;
import net.minestom.server.network.packet.server.play.SpawnExperienceOrbPacket;
import net.minestom.server.network.packet.server.play.SpawnPositionPacket;
import net.minestom.server.network.packet.server.play.StartConfigurationPacket;
import net.minestom.server.network.packet.server.play.StatisticsPacket;
import net.minestom.server.network.packet.server.play.StopSoundPacket;
import net.minestom.server.network.packet.server.play.SystemChatPacket;
import net.minestom.server.network.packet.server.play.TabCompletePacket;
import net.minestom.server.network.packet.server.play.TeamsPacket;
import net.minestom.server.network.packet.server.play.TickStepPacket;
import net.minestom.server.network.packet.server.play.TimeUpdatePacket;
import net.minestom.server.network.packet.server.play.TradeListPacket;
import net.minestom.server.network.packet.server.play.UnloadChunkPacket;
import net.minestom.server.network.packet.server.play.UpdateHealthPacket;
import net.minestom.server.network.packet.server.play.UpdateLightPacket;
import net.minestom.server.network.packet.server.play.UpdateScorePacket;
import net.minestom.server.network.packet.server.play.UpdateSimulationDistancePacket;
import net.minestom.server.network.packet.server.play.UpdateViewDistancePacket;
import net.minestom.server.network.packet.server.play.UpdateViewPositionPacket;
import net.minestom.server.network.packet.server.play.VehicleMovePacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.network.packet.server.play.WindowPropertyPacket;
import net.minestom.server.network.packet.server.play.WorldBorderCenterPacket;
import net.minestom.server.network.packet.server.play.WorldBorderLerpSizePacket;
import net.minestom.server.network.packet.server.play.WorldBorderSizePacket;
import net.minestom.server.network.packet.server.play.WorldBorderWarningDelayPacket;
import net.minestom.server.network.packet.server.play.WorldBorderWarningReachPacket;
import net.minestom.server.network.packet.server.play.WorldEventPacket;
import net.minestom.server.network.packet.server.status.ResponsePacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public interface PacketRegistry<T> {
    public @UnknownNullability T create(int var1, @NotNull NetworkBuffer var2);

    public PacketInfo<T> packetInfo(@NotNull Class<?> var1);

    default public PacketInfo<T> packetInfo(@NotNull T packet) {
        return this.packetInfo((T)packet.getClass());
    }

    public PacketInfo<T> packetInfo(int var1);

    @NotNull
    public ConnectionState state();

    @NotNull
    public ConnectionSide side();

    public record PacketInfo<T>(Class<T> packetClass, int id, NetworkBuffer.Type<T> serializer) {
    }

    public static enum ConnectionSide {
        CLIENT,
        SERVER;

    }

    public static abstract sealed class PacketRegistryTemplate<T>
    implements PacketRegistry<T>
    permits Client, Server {
        private final PacketInfo<? extends T>[] suppliers;
        private final ClassValue<PacketInfo<T>> packetIds = new ClassValue<PacketInfo<T>>(){

            @Override
            protected PacketInfo<T> computeValue(@NotNull Class<?> type) {
                for (PacketInfo info : suppliers) {
                    if (info == null || info.packetClass != type) continue;
                    return info;
                }
                throw new IllegalStateException("Packet type " + String.valueOf(type) + " cannot be sent in state " + this.side().name() + "_" + this.state().name() + "!");
            }
        };

        @SafeVarargs
        PacketRegistryTemplate(Entry<? extends T> ... suppliers) {
            PacketInfo[] packetInfos = new PacketInfo[suppliers.length];
            for (int i = 0; i < suppliers.length; ++i) {
                Entry<? extends T> entry = suppliers[i];
                if (entry == null) continue;
                packetInfos[i] = new PacketInfo(entry.type, i, entry.reader);
            }
            this.suppliers = packetInfos;
        }

        @Override
        public @UnknownNullability T create(int packetId, @NotNull NetworkBuffer reader) {
            PacketInfo<T> info = this.packetInfo(packetId);
            NetworkBuffer.Type supplier = info.serializer;
            Object packet = supplier.read(reader);
            if (packet == null) {
                throw new IllegalStateException("Packet " + String.valueOf(info.packetClass) + " failed to read!");
            }
            return packet;
        }

        @Override
        public PacketInfo<T> packetInfo(@NotNull Class<?> packetClass) {
            return this.packetIds.get(packetClass);
        }

        @Override
        public PacketInfo<T> packetInfo(int packetId) {
            PacketInfo<? extends T> info;
            if (packetId < 0 || packetId >= this.suppliers.length || (info = this.suppliers[packetId]) == null) {
                throw new IllegalStateException("Packet id 0x" + Integer.toHexString(packetId) + " isn't registered!");
            }
            return info;
        }

        static <T> Entry<T> entry(Class<T> type, NetworkBuffer.Type<T> reader) {
            return new Entry<T>(type, reader);
        }

        record Entry<T>(Class<T> type, NetworkBuffer.Type<T> reader) {
        }
    }

    public static final class ServerPlay
    extends Server {
        public ServerPlay() {
            super(new PacketRegistryTemplate.Entry[]{ServerPlay.entry(BundlePacket.class, BundlePacket.SERIALIZER), ServerPlay.entry(SpawnEntityPacket.class, SpawnEntityPacket.SERIALIZER), ServerPlay.entry(SpawnExperienceOrbPacket.class, SpawnExperienceOrbPacket.SERIALIZER), ServerPlay.entry(EntityAnimationPacket.class, EntityAnimationPacket.SERIALIZER), ServerPlay.entry(StatisticsPacket.class, StatisticsPacket.SERIALIZER), ServerPlay.entry(AcknowledgeBlockChangePacket.class, AcknowledgeBlockChangePacket.SERIALIZER), ServerPlay.entry(BlockBreakAnimationPacket.class, BlockBreakAnimationPacket.SERIALIZER), ServerPlay.entry(BlockEntityDataPacket.class, BlockEntityDataPacket.SERIALIZER), ServerPlay.entry(BlockActionPacket.class, BlockActionPacket.SERIALIZER), ServerPlay.entry(BlockChangePacket.class, BlockChangePacket.SERIALIZER), ServerPlay.entry(BossBarPacket.class, BossBarPacket.SERIALIZER), ServerPlay.entry(ServerDifficultyPacket.class, ServerDifficultyPacket.SERIALIZER), ServerPlay.entry(ChunkBatchFinishedPacket.class, ChunkBatchFinishedPacket.SERIALIZER), ServerPlay.entry(ChunkBatchStartPacket.class, ChunkBatchStartPacket.SERIALIZER), ServerPlay.entry(ChunkBiomesPacket.class, ChunkBiomesPacket.SERIALIZER), ServerPlay.entry(ClearTitlesPacket.class, ClearTitlesPacket.SERIALIZER), ServerPlay.entry(TabCompletePacket.class, TabCompletePacket.SERIALIZER), ServerPlay.entry(DeclareCommandsPacket.class, DeclareCommandsPacket.SERIALIZER), ServerPlay.entry(CloseWindowPacket.class, CloseWindowPacket.SERIALIZER), ServerPlay.entry(WindowItemsPacket.class, WindowItemsPacket.SERIALIZER), ServerPlay.entry(WindowPropertyPacket.class, WindowPropertyPacket.SERIALIZER), ServerPlay.entry(SetSlotPacket.class, SetSlotPacket.SERIALIZER), ServerPlay.entry(CookieRequestPacket.class, CookieRequestPacket.SERIALIZER), ServerPlay.entry(SetCooldownPacket.class, SetCooldownPacket.SERIALIZER), ServerPlay.entry(CustomChatCompletionPacket.class, CustomChatCompletionPacket.SERIALIZER), ServerPlay.entry(PluginMessagePacket.class, PluginMessagePacket.SERIALIZER), ServerPlay.entry(DamageEventPacket.class, DamageEventPacket.SERIALIZER), ServerPlay.entry(DebugSamplePacket.class, DebugSamplePacket.SERIALIZER), ServerPlay.entry(DeleteChatPacket.class, DeleteChatPacket.SERIALIZER), ServerPlay.entry(DisconnectPacket.class, DisconnectPacket.SERIALIZER), ServerPlay.entry(DisguisedChatPacket.class, DisguisedChatPacket.SERIALIZER), ServerPlay.entry(EntityStatusPacket.class, EntityStatusPacket.SERIALIZER), ServerPlay.entry(EntityPositionSyncPacket.class, EntityPositionSyncPacket.SERIALIZER), ServerPlay.entry(ExplosionPacket.class, ExplosionPacket.SERIALIZER), ServerPlay.entry(UnloadChunkPacket.class, UnloadChunkPacket.SERIALIZER), ServerPlay.entry(ChangeGameStatePacket.class, ChangeGameStatePacket.SERIALIZER), ServerPlay.entry(OpenHorseWindowPacket.class, OpenHorseWindowPacket.SERIALIZER), ServerPlay.entry(HitAnimationPacket.class, HitAnimationPacket.SERIALIZER), ServerPlay.entry(InitializeWorldBorderPacket.class, InitializeWorldBorderPacket.SERIALIZER), ServerPlay.entry(KeepAlivePacket.class, KeepAlivePacket.SERIALIZER), ServerPlay.entry(ChunkDataPacket.class, ChunkDataPacket.SERIALIZER), ServerPlay.entry(WorldEventPacket.class, WorldEventPacket.SERIALIZER), ServerPlay.entry(ParticlePacket.class, ParticlePacket.SERIALIZER), ServerPlay.entry(UpdateLightPacket.class, UpdateLightPacket.SERIALIZER), ServerPlay.entry(JoinGamePacket.class, JoinGamePacket.SERIALIZER), ServerPlay.entry(MapDataPacket.class, MapDataPacket.SERIALIZER), ServerPlay.entry(TradeListPacket.class, TradeListPacket.SERIALIZER), ServerPlay.entry(EntityPositionPacket.class, EntityPositionPacket.SERIALIZER), ServerPlay.entry(EntityPositionAndRotationPacket.class, EntityPositionAndRotationPacket.SERIALIZER), ServerPlay.entry(MoveMinecartPacket.class, MoveMinecartPacket.SERIALIZER), ServerPlay.entry(EntityRotationPacket.class, EntityRotationPacket.SERIALIZER), ServerPlay.entry(VehicleMovePacket.class, VehicleMovePacket.SERIALIZER), ServerPlay.entry(OpenBookPacket.class, OpenBookPacket.SERIALIZER), ServerPlay.entry(OpenWindowPacket.class, OpenWindowPacket.SERIALIZER), ServerPlay.entry(OpenSignEditorPacket.class, OpenSignEditorPacket.SERIALIZER), ServerPlay.entry(PingPacket.class, PingPacket.SERIALIZER), ServerPlay.entry(PingResponsePacket.class, PingResponsePacket.SERIALIZER), ServerPlay.entry(PlaceGhostRecipePacket.class, PlaceGhostRecipePacket.SERIALIZER), ServerPlay.entry(PlayerAbilitiesPacket.class, PlayerAbilitiesPacket.SERIALIZER), ServerPlay.entry(PlayerChatMessagePacket.class, PlayerChatMessagePacket.SERIALIZER), ServerPlay.entry(EndCombatEventPacket.class, EndCombatEventPacket.SERIALIZER), ServerPlay.entry(EnterCombatEventPacket.class, EnterCombatEventPacket.SERIALIZER), ServerPlay.entry(DeathCombatEventPacket.class, DeathCombatEventPacket.SERIALIZER), ServerPlay.entry(PlayerInfoRemovePacket.class, PlayerInfoRemovePacket.SERIALIZER), ServerPlay.entry(PlayerInfoUpdatePacket.class, PlayerInfoUpdatePacket.SERIALIZER), ServerPlay.entry(FacePlayerPacket.class, FacePlayerPacket.SERIALIZER), ServerPlay.entry(PlayerPositionAndLookPacket.class, PlayerPositionAndLookPacket.SERIALIZER), ServerPlay.entry(PlayerRotationPacket.class, PlayerRotationPacket.SERIALIZER), ServerPlay.entry(RecipeBookAddPacket.class, RecipeBookAddPacket.SERIALIZER), ServerPlay.entry(RecipeBookRemovePacket.class, RecipeBookRemovePacket.SERIALIZER), ServerPlay.entry(RecipeBookSettingsPacket.class, RecipeBookSettingsPacket.SERIALIZER), ServerPlay.entry(DestroyEntitiesPacket.class, DestroyEntitiesPacket.SERIALIZER), ServerPlay.entry(RemoveEntityEffectPacket.class, RemoveEntityEffectPacket.SERIALIZER), ServerPlay.entry(ResetScorePacket.class, ResetScorePacket.SERIALIZER), ServerPlay.entry(ResourcePackPopPacket.class, ResourcePackPopPacket.SERIALIZER), ServerPlay.entry(ResourcePackPushPacket.class, ResourcePackPushPacket.SERIALIZER), ServerPlay.entry(RespawnPacket.class, RespawnPacket.SERIALIZER), ServerPlay.entry(EntityHeadLookPacket.class, EntityHeadLookPacket.SERIALIZER), ServerPlay.entry(MultiBlockChangePacket.class, MultiBlockChangePacket.SERIALIZER), ServerPlay.entry(SelectAdvancementTabPacket.class, SelectAdvancementTabPacket.SERIALIZER), ServerPlay.entry(ServerDataPacket.class, ServerDataPacket.SERIALIZER), ServerPlay.entry(ActionBarPacket.class, ActionBarPacket.SERIALIZER), ServerPlay.entry(WorldBorderCenterPacket.class, WorldBorderCenterPacket.SERIALIZER), ServerPlay.entry(WorldBorderLerpSizePacket.class, WorldBorderLerpSizePacket.SERIALIZER), ServerPlay.entry(WorldBorderSizePacket.class, WorldBorderSizePacket.SERIALIZER), ServerPlay.entry(WorldBorderWarningDelayPacket.class, WorldBorderWarningDelayPacket.SERIALIZER), ServerPlay.entry(WorldBorderWarningReachPacket.class, WorldBorderWarningReachPacket.SERIALIZER), ServerPlay.entry(CameraPacket.class, CameraPacket.SERIALIZER), ServerPlay.entry(UpdateViewPositionPacket.class, UpdateViewPositionPacket.SERIALIZER), ServerPlay.entry(UpdateViewDistancePacket.class, UpdateViewDistancePacket.SERIALIZER), ServerPlay.entry(SetCursorItemPacket.class, SetCursorItemPacket.SERIALIZER), ServerPlay.entry(SpawnPositionPacket.class, SpawnPositionPacket.SERIALIZER), ServerPlay.entry(DisplayScoreboardPacket.class, DisplayScoreboardPacket.SERIALIZER), ServerPlay.entry(EntityMetaDataPacket.class, EntityMetaDataPacket.SERIALIZER), ServerPlay.entry(AttachEntityPacket.class, AttachEntityPacket.SERIALIZER), ServerPlay.entry(EntityVelocityPacket.class, EntityVelocityPacket.SERIALIZER), ServerPlay.entry(EntityEquipmentPacket.class, EntityEquipmentPacket.SERIALIZER), ServerPlay.entry(SetExperiencePacket.class, SetExperiencePacket.SERIALIZER), ServerPlay.entry(UpdateHealthPacket.class, UpdateHealthPacket.SERIALIZER), ServerPlay.entry(HeldItemChangePacket.class, HeldItemChangePacket.SERIALIZER), ServerPlay.entry(ScoreboardObjectivePacket.class, ScoreboardObjectivePacket.SERIALIZER), ServerPlay.entry(SetPassengersPacket.class, SetPassengersPacket.SERIALIZER), ServerPlay.entry(SetPlayerInventorySlotPacket.class, SetPlayerInventorySlotPacket.SERIALIZER), ServerPlay.entry(TeamsPacket.class, TeamsPacket.SERIALIZER), ServerPlay.entry(UpdateScorePacket.class, UpdateScorePacket.SERIALIZER), ServerPlay.entry(UpdateSimulationDistancePacket.class, UpdateSimulationDistancePacket.SERIALIZER), ServerPlay.entry(SetTitleSubTitlePacket.class, SetTitleSubTitlePacket.SERIALIZER), ServerPlay.entry(TimeUpdatePacket.class, TimeUpdatePacket.SERIALIZER), ServerPlay.entry(SetTitleTextPacket.class, SetTitleTextPacket.SERIALIZER), ServerPlay.entry(SetTitleTimePacket.class, SetTitleTimePacket.SERIALIZER), ServerPlay.entry(EntitySoundEffectPacket.class, EntitySoundEffectPacket.SERIALIZER), ServerPlay.entry(SoundEffectPacket.class, SoundEffectPacket.SERIALIZER), ServerPlay.entry(StartConfigurationPacket.class, StartConfigurationPacket.SERIALIZER), ServerPlay.entry(StopSoundPacket.class, StopSoundPacket.SERIALIZER), ServerPlay.entry(CookieStorePacket.class, CookieStorePacket.SERIALIZER), ServerPlay.entry(SystemChatPacket.class, SystemChatPacket.SERIALIZER), ServerPlay.entry(PlayerListHeaderAndFooterPacket.class, PlayerListHeaderAndFooterPacket.SERIALIZER), ServerPlay.entry(NbtQueryResponsePacket.class, NbtQueryResponsePacket.SERIALIZER), ServerPlay.entry(CollectItemPacket.class, CollectItemPacket.SERIALIZER), ServerPlay.entry(EntityTeleportPacket.class, EntityTeleportPacket.SERIALIZER), ServerPlay.entry(SetTickStatePacket.class, SetTickStatePacket.SERIALIZER), ServerPlay.entry(TickStepPacket.class, TickStepPacket.SERIALIZER), ServerPlay.entry(TransferPacket.class, TransferPacket.SERIALIZER), ServerPlay.entry(AdvancementsPacket.class, AdvancementsPacket.SERIALIZER), ServerPlay.entry(EntityAttributesPacket.class, EntityAttributesPacket.SERIALIZER), ServerPlay.entry(EntityEffectPacket.class, EntityEffectPacket.SERIALIZER), ServerPlay.entry(DeclareRecipesPacket.class, DeclareRecipesPacket.SERIALIZER), ServerPlay.entry(TagsPacket.class, TagsPacket.SERIALIZER), ServerPlay.entry(ProjectilePowerPacket.class, ProjectilePowerPacket.SERIALIZER), ServerPlay.entry(CustomReportDetailsPacket.class, CustomReportDetailsPacket.SERIALIZER), ServerPlay.entry(ServerLinksPacket.class, ServerLinksPacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.PLAY;
        }
    }

    public static final class ServerConfiguration
    extends Server {
        public ServerConfiguration() {
            super(new PacketRegistryTemplate.Entry[]{ServerConfiguration.entry(CookieRequestPacket.class, CookieRequestPacket.SERIALIZER), ServerConfiguration.entry(PluginMessagePacket.class, PluginMessagePacket.SERIALIZER), ServerConfiguration.entry(DisconnectPacket.class, DisconnectPacket.SERIALIZER), ServerConfiguration.entry(FinishConfigurationPacket.class, FinishConfigurationPacket.SERIALIZER), ServerConfiguration.entry(KeepAlivePacket.class, KeepAlivePacket.SERIALIZER), ServerConfiguration.entry(PingPacket.class, PingPacket.SERIALIZER), ServerConfiguration.entry(ResetChatPacket.class, ResetChatPacket.SERIALIZER), ServerConfiguration.entry(RegistryDataPacket.class, RegistryDataPacket.SERIALIZER), ServerConfiguration.entry(ResourcePackPopPacket.class, ResourcePackPopPacket.SERIALIZER), ServerConfiguration.entry(ResourcePackPushPacket.class, ResourcePackPushPacket.SERIALIZER), ServerConfiguration.entry(CookieStorePacket.class, CookieStorePacket.SERIALIZER), ServerConfiguration.entry(TransferPacket.class, TransferPacket.SERIALIZER), ServerConfiguration.entry(UpdateEnabledFeaturesPacket.class, UpdateEnabledFeaturesPacket.SERIALIZER), ServerConfiguration.entry(TagsPacket.class, TagsPacket.SERIALIZER), ServerConfiguration.entry(SelectKnownPacksPacket.class, SelectKnownPacksPacket.SERIALIZER), ServerConfiguration.entry(CustomReportDetailsPacket.class, CustomReportDetailsPacket.SERIALIZER), ServerConfiguration.entry(ServerLinksPacket.class, ServerLinksPacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.CONFIGURATION;
        }
    }

    public static final class ServerLogin
    extends Server {
        public ServerLogin() {
            super(new PacketRegistryTemplate.Entry[]{ServerLogin.entry(LoginDisconnectPacket.class, LoginDisconnectPacket.SERIALIZER), ServerLogin.entry(EncryptionRequestPacket.class, EncryptionRequestPacket.SERIALIZER), ServerLogin.entry(LoginSuccessPacket.class, LoginSuccessPacket.SERIALIZER), ServerLogin.entry(SetCompressionPacket.class, SetCompressionPacket.SERIALIZER), ServerLogin.entry(LoginPluginRequestPacket.class, LoginPluginRequestPacket.SERIALIZER), ServerLogin.entry(CookieRequestPacket.class, CookieRequestPacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.LOGIN;
        }
    }

    public static final class ServerStatus
    extends Server {
        public ServerStatus() {
            super(new PacketRegistryTemplate.Entry[]{ServerStatus.entry(ResponsePacket.class, ResponsePacket.SERIALIZER), ServerStatus.entry(PingResponsePacket.class, PingResponsePacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.STATUS;
        }
    }

    public static final class ServerHandshake
    extends Server {
        public ServerHandshake() {
            super(new PacketRegistryTemplate.Entry[0]);
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.HANDSHAKE;
        }
    }

    public static abstract sealed class Server
    extends PacketRegistryTemplate<ServerPacket>
    permits ServerHandshake, ServerStatus, ServerLogin, ServerConfiguration, ServerPlay {
        @SafeVarargs
        Server(PacketRegistryTemplate.Entry<? extends ServerPacket> ... suppliers) {
            super(suppliers);
        }

        @Override
        @NotNull
        public ConnectionSide side() {
            return ConnectionSide.SERVER;
        }
    }

    public static final class ClientPlay
    extends Client {
        public ClientPlay() {
            super(new PacketRegistryTemplate.Entry[]{ClientPlay.entry(ClientTeleportConfirmPacket.class, ClientTeleportConfirmPacket.SERIALIZER), ClientPlay.entry(ClientQueryBlockNbtPacket.class, ClientQueryBlockNbtPacket.SERIALIZER), ClientPlay.entry(ClientSelectBundleItemPacket.class, ClientSelectBundleItemPacket.SERIALIZER), ClientPlay.entry(ClientChangeDifficultyPacket.class, ClientChangeDifficultyPacket.SERIALIZER), ClientPlay.entry(ClientChatAckPacket.class, ClientChatAckPacket.SERIALIZER), ClientPlay.entry(ClientCommandChatPacket.class, ClientCommandChatPacket.SERIALIZER), ClientPlay.entry(ClientSignedCommandChatPacket.class, ClientSignedCommandChatPacket.SERIALIZER), ClientPlay.entry(ClientChatMessagePacket.class, ClientChatMessagePacket.SERIALIZER), ClientPlay.entry(ClientChatSessionUpdatePacket.class, ClientChatSessionUpdatePacket.SERIALIZER), ClientPlay.entry(ClientChunkBatchReceivedPacket.class, ClientChunkBatchReceivedPacket.SERIALIZER), ClientPlay.entry(ClientStatusPacket.class, ClientStatusPacket.SERIALIZER), ClientPlay.entry(ClientTickEndPacket.class, ClientTickEndPacket.SERIALIZER), ClientPlay.entry(ClientSettingsPacket.class, ClientSettingsPacket.SERIALIZER), ClientPlay.entry(ClientTabCompletePacket.class, ClientTabCompletePacket.SERIALIZER), ClientPlay.entry(ClientConfigurationAckPacket.class, ClientConfigurationAckPacket.SERIALIZER), ClientPlay.entry(ClientClickWindowButtonPacket.class, ClientClickWindowButtonPacket.SERIALIZER), ClientPlay.entry(ClientClickWindowPacket.class, ClientClickWindowPacket.SERIALIZER), ClientPlay.entry(ClientCloseWindowPacket.class, ClientCloseWindowPacket.SERIALIZER), ClientPlay.entry(ClientWindowSlotStatePacket.class, ClientWindowSlotStatePacket.SERIALIZER), ClientPlay.entry(ClientCookieResponsePacket.class, ClientCookieResponsePacket.SERIALIZER), ClientPlay.entry(ClientPluginMessagePacket.class, ClientPluginMessagePacket.SERIALIZER), ClientPlay.entry(ClientDebugSampleSubscriptionPacket.class, ClientDebugSampleSubscriptionPacket.SERIALIZER), ClientPlay.entry(ClientEditBookPacket.class, ClientEditBookPacket.SERIALIZER), ClientPlay.entry(ClientQueryEntityNbtPacket.class, ClientQueryEntityNbtPacket.SERIALIZER), ClientPlay.entry(ClientInteractEntityPacket.class, ClientInteractEntityPacket.SERIALIZER), ClientPlay.entry(ClientGenerateStructurePacket.class, ClientGenerateStructurePacket.SERIALIZER), ClientPlay.entry(ClientKeepAlivePacket.class, ClientKeepAlivePacket.SERIALIZER), ClientPlay.entry(ClientLockDifficultyPacket.class, ClientLockDifficultyPacket.SERIALIZER), ClientPlay.entry(ClientPlayerPositionPacket.class, ClientPlayerPositionPacket.SERIALIZER), ClientPlay.entry(ClientPlayerPositionAndRotationPacket.class, ClientPlayerPositionAndRotationPacket.SERIALIZER), ClientPlay.entry(ClientPlayerRotationPacket.class, ClientPlayerRotationPacket.SERIALIZER), ClientPlay.entry(ClientPlayerPositionStatusPacket.class, ClientPlayerPositionStatusPacket.SERIALIZER), ClientPlay.entry(ClientVehicleMovePacket.class, ClientVehicleMovePacket.SERIALIZER), ClientPlay.entry(ClientSteerBoatPacket.class, ClientSteerBoatPacket.SERIALIZER), ClientPlay.entry(ClientPickItemFromBlockPacket.class, ClientPickItemFromBlockPacket.SERIALIZER), ClientPlay.entry(ClientPickItemFromEntityPacket.class, ClientPickItemFromEntityPacket.SERIALIZER), ClientPlay.entry(ClientPingRequestPacket.class, ClientPingRequestPacket.SERIALIZER), ClientPlay.entry(ClientPlaceRecipePacket.class, ClientPlaceRecipePacket.SERIALIZER), ClientPlay.entry(ClientPlayerAbilitiesPacket.class, ClientPlayerAbilitiesPacket.SERIALIZER), ClientPlay.entry(ClientPlayerDiggingPacket.class, ClientPlayerDiggingPacket.SERIALIZER), ClientPlay.entry(ClientEntityActionPacket.class, ClientEntityActionPacket.SERIALIZER), ClientPlay.entry(ClientInputPacket.class, ClientInputPacket.SERIALIZER), ClientPlay.entry(ClientPlayerLoadedPacket.class, ClientPlayerLoadedPacket.SERIALIZER), ClientPlay.entry(ClientPongPacket.class, ClientPongPacket.SERIALIZER), ClientPlay.entry(ClientSetRecipeBookStatePacket.class, ClientSetRecipeBookStatePacket.SERIALIZER), ClientPlay.entry(ClientRecipeBookSeenRecipePacket.class, ClientRecipeBookSeenRecipePacket.SERIALIZER), ClientPlay.entry(ClientNameItemPacket.class, ClientNameItemPacket.SERIALIZER), ClientPlay.entry(ClientResourcePackStatusPacket.class, ClientResourcePackStatusPacket.SERIALIZER), ClientPlay.entry(ClientAdvancementTabPacket.class, ClientAdvancementTabPacket.SERIALIZER), ClientPlay.entry(ClientSelectTradePacket.class, ClientSelectTradePacket.SERIALIZER), ClientPlay.entry(ClientSetBeaconEffectPacket.class, ClientSetBeaconEffectPacket.SERIALIZER), ClientPlay.entry(ClientHeldItemChangePacket.class, ClientHeldItemChangePacket.SERIALIZER), ClientPlay.entry(ClientUpdateCommandBlockPacket.class, ClientUpdateCommandBlockPacket.SERIALIZER), ClientPlay.entry(ClientUpdateCommandBlockMinecartPacket.class, ClientUpdateCommandBlockMinecartPacket.SERIALIZER), ClientPlay.entry(ClientCreativeInventoryActionPacket.class, ClientCreativeInventoryActionPacket.SERIALIZER), ClientPlay.entry(ClientUpdateJigsawBlockPacket.class, ClientUpdateJigsawBlockPacket.SERIALIZER), ClientPlay.entry(ClientUpdateStructureBlockPacket.class, ClientUpdateStructureBlockPacket.SERIALIZER), ClientPlay.entry(ClientUpdateSignPacket.class, ClientUpdateSignPacket.SERIALIZER), ClientPlay.entry(ClientAnimationPacket.class, ClientAnimationPacket.SERIALIZER), ClientPlay.entry(ClientSpectatePacket.class, ClientSpectatePacket.SERIALIZER), ClientPlay.entry(ClientPlayerBlockPlacementPacket.class, ClientPlayerBlockPlacementPacket.SERIALIZER), ClientPlay.entry(ClientUseItemPacket.class, ClientUseItemPacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.PLAY;
        }
    }

    public static final class ClientConfiguration
    extends Client {
        public ClientConfiguration() {
            super(new PacketRegistryTemplate.Entry[]{ClientConfiguration.entry(ClientSettingsPacket.class, ClientSettingsPacket.SERIALIZER), ClientConfiguration.entry(ClientCookieResponsePacket.class, ClientCookieResponsePacket.SERIALIZER), ClientConfiguration.entry(ClientPluginMessagePacket.class, ClientPluginMessagePacket.SERIALIZER), ClientConfiguration.entry(ClientFinishConfigurationPacket.class, ClientFinishConfigurationPacket.SERIALIZER), ClientConfiguration.entry(ClientKeepAlivePacket.class, ClientKeepAlivePacket.SERIALIZER), ClientConfiguration.entry(ClientPongPacket.class, ClientPongPacket.SERIALIZER), ClientConfiguration.entry(ClientResourcePackStatusPacket.class, ClientResourcePackStatusPacket.SERIALIZER), ClientConfiguration.entry(ClientSelectKnownPacksPacket.class, ClientSelectKnownPacksPacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.CONFIGURATION;
        }
    }

    public static final class ClientLogin
    extends Client {
        public ClientLogin() {
            super(new PacketRegistryTemplate.Entry[]{ClientLogin.entry(ClientLoginStartPacket.class, ClientLoginStartPacket.SERIALIZER), ClientLogin.entry(ClientEncryptionResponsePacket.class, ClientEncryptionResponsePacket.SERIALIZER), ClientLogin.entry(ClientLoginPluginResponsePacket.class, ClientLoginPluginResponsePacket.SERIALIZER), ClientLogin.entry(ClientLoginAcknowledgedPacket.class, ClientLoginAcknowledgedPacket.SERIALIZER), ClientLogin.entry(ClientCookieResponsePacket.class, ClientCookieResponsePacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.LOGIN;
        }
    }

    public static final class ClientStatus
    extends Client {
        public ClientStatus() {
            super(new PacketRegistryTemplate.Entry[]{ClientStatus.entry(StatusRequestPacket.class, StatusRequestPacket.SERIALIZER), ClientStatus.entry(ClientPingRequestPacket.class, ClientPingRequestPacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.STATUS;
        }
    }

    public static final class ClientHandshake
    extends Client {
        public ClientHandshake() {
            super(new PacketRegistryTemplate.Entry[]{ClientHandshake.entry(ClientHandshakePacket.class, ClientHandshakePacket.SERIALIZER)});
        }

        @Override
        @NotNull
        public ConnectionState state() {
            return ConnectionState.HANDSHAKE;
        }
    }

    public static abstract sealed class Client
    extends PacketRegistryTemplate<ClientPacket>
    permits ClientHandshake, ClientStatus, ClientLogin, ClientConfiguration, ClientPlay {
        @SafeVarargs
        Client(PacketRegistryTemplate.Entry<? extends ClientPacket> ... suppliers) {
            super(suppliers);
        }

        @Override
        @NotNull
        public ConnectionSide side() {
            return ConnectionSide.CLIENT;
        }
    }
}

