package net.minestom.server.recipe.display;

import net.kyori.adventure.key.Key;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

/**
 * AUTOGENERATED by GenericEnumGenerator
 */
public enum SlotDisplayType implements StaticProtocolObject {
    EMPTY(Key.key("minecraft:empty")),

    ANY_FUEL(Key.key("minecraft:any_fuel")),

    ITEM(Key.key("minecraft:item")),

    ITEM_STACK(Key.key("minecraft:item_stack")),

    TAG(Key.key("minecraft:tag")),

    SMITHING_TRIM(Key.key("minecraft:smithing_trim")),

    WITH_REMAINDER(Key.key("minecraft:with_remainder")),

    COMPOSITE(Key.key("minecraft:composite"));

    public static final NetworkBuffer.Type<SlotDisplayType> NETWORK_TYPE = NetworkBuffer.Enum(SlotDisplayType.class);

    public static final BinaryTagSerializer<SlotDisplayType> NBT_TYPE = BinaryTagSerializer.fromEnumKeyed(SlotDisplayType.class);

    private final Key key;

    SlotDisplayType(@NotNull Key key) {
        this.key = key;
    }

    @NotNull
    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }
}
