/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minestom.server.MinecraftServer;
import net.minestom.server.timer.ExecutionType;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.timer.Task;
import net.minestom.server.timer.TaskImpl;
import net.minestom.server.timer.TaskSchedule;
import net.minestom.server.timer.TaskScheduleImpl;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.NotNull;

final class SchedulerImpl
implements Scheduler {
    private static final AtomicInteger TASK_COUNTER = new AtomicInteger();
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        return thread;
    });
    private static final ForkJoinPool EXECUTOR = ForkJoinPool.commonPool();
    private final MpscUnboundedArrayQueue<TaskImpl> taskQueue = new MpscUnboundedArrayQueue(64);
    private final Int2ObjectAVLTreeMap<List<TaskImpl>> tickTaskQueue = new Int2ObjectAVLTreeMap();
    private int tickState;

    SchedulerImpl() {
    }

    @Override
    public void process() {
        this.processTick(0);
    }

    @Override
    public void processTick() {
        this.processTick(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTick(int tickDelta) {
        SchedulerImpl schedulerImpl = this;
        synchronized (schedulerImpl) {
            int tickToProcess;
            this.tickState += tickDelta;
            while (!this.tickTaskQueue.isEmpty() && (tickToProcess = this.tickTaskQueue.firstIntKey()) <= this.tickState) {
                List tickScheduledTasks = (List)this.tickTaskQueue.remove(tickToProcess);
                if (tickScheduledTasks == null) continue;
                tickScheduledTasks.forEach(x$0 -> this.taskQueue.relaxedOffer(x$0));
            }
        }
        if (!this.taskQueue.isEmpty()) {
            this.taskQueue.drain(task -> {
                if (!task.isAlive()) {
                    return;
                }
                switch (task.executionType()) {
                    case SYNC: {
                        this.handleTask((TaskImpl)task);
                        break;
                    }
                    case ASYNC: {
                        EXECUTOR.submit(() -> this.handleTask((TaskImpl)task));
                    }
                }
            });
        }
    }

    @Override
    @NotNull
    public Task submitTask(@NotNull Supplier<TaskSchedule> task, @NotNull ExecutionType executionType) {
        TaskImpl taskRef = new TaskImpl(TASK_COUNTER.getAndIncrement(), task, executionType, this);
        this.handleTask(taskRef);
        return taskRef;
    }

    void unparkTask(TaskImpl task) {
        if (task.tryUnpark()) {
            this.taskQueue.relaxedOffer((Object)task);
        }
    }

    private void safeExecute(TaskImpl task) {
        switch (task.executionType()) {
            case SYNC: {
                this.taskQueue.offer((Object)task);
                break;
            }
            case ASYNC: {
                EXECUTOR.submit(() -> {
                    if (!task.isAlive()) {
                        return;
                    }
                    this.handleTask(task);
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTask(TaskImpl task) {
        TaskSchedule schedule;
        try {
            schedule = task.task().get();
        }
        catch (Throwable t) {
            MinecraftServer.getExceptionManager().handleException(new RuntimeException("Exception in scheduled task", t));
            schedule = TaskSchedule.stop();
        }
        if (schedule instanceof TaskScheduleImpl.DurationSchedule) {
            TaskScheduleImpl.DurationSchedule durationSchedule = (TaskScheduleImpl.DurationSchedule)schedule;
            Duration duration = durationSchedule.duration();
            SCHEDULER.schedule(() -> this.safeExecute(task), duration.toMillis(), TimeUnit.MILLISECONDS);
        } else if (schedule instanceof TaskScheduleImpl.TickSchedule) {
            TaskScheduleImpl.TickSchedule tickSchedule = (TaskScheduleImpl.TickSchedule)schedule;
            SchedulerImpl schedulerImpl = this;
            synchronized (schedulerImpl) {
                int target = this.tickState + tickSchedule.tick();
                ((List)this.tickTaskQueue.computeIfAbsent(target, i -> new ArrayList())).add(task);
            }
        } else if (schedule instanceof TaskScheduleImpl.FutureSchedule) {
            TaskScheduleImpl.FutureSchedule futureSchedule = (TaskScheduleImpl.FutureSchedule)schedule;
            futureSchedule.future().thenRun(() -> this.safeExecute(task));
        } else if (schedule instanceof TaskScheduleImpl.Park) {
            task.parked = true;
        } else if (schedule instanceof TaskScheduleImpl.Stop) {
            task.cancel();
        } else if (schedule instanceof TaskScheduleImpl.Immediate) {
            this.taskQueue.relaxedOffer((Object)task);
        }
    }
}

