/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import net.minestom.server.MinecraftServer;
import net.minestom.server.crypto.PlayerPublicKey;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.SendablePacket;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerConnection {
    private Player player;
    private volatile ConnectionState connectionState = ConnectionState.HANDSHAKE;
    private PlayerPublicKey playerPublicKey;
    volatile boolean online = true;

    @NotNull
    public String getIdentifier() {
        Player player = this.getPlayer();
        return player != null ? player.getUsername() : this.getRemoteAddress().toString();
    }

    public abstract void sendPacket(@NotNull SendablePacket var1);

    @ApiStatus.Experimental
    public void sendPackets(@NotNull Collection<SendablePacket> packets) {
        packets.forEach(this::sendPacket);
    }

    @ApiStatus.Experimental
    public void sendPackets(SendablePacket ... packets) {
        this.sendPackets(List.of(packets));
    }

    @NotNull
    public abstract SocketAddress getRemoteAddress();

    public int getProtocolVersion() {
        return 765;
    }

    @Nullable
    public String getServerAddress() {
        return MinecraftServer.getServer().getAddress();
    }

    public int getServerPort() {
        return MinecraftServer.getServer().getPort();
    }

    public void disconnect() {
        this.online = false;
        MinecraftServer.getConnectionManager().removePlayer(this);
        Player player = this.getPlayer();
        if (player != null && !player.isRemoved()) {
            player.scheduleNextTick(Entity::remove);
        }
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setConnectionState(@NotNull ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    @NotNull
    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public PlayerPublicKey playerPublicKey() {
        return this.playerPublicKey;
    }

    public void setPlayerPublicKey(PlayerPublicKey playerPublicKey) {
        this.playerPublicKey = playerPublicKey;
    }

    public String toString() {
        return "PlayerConnection{connectionState=" + this.connectionState + ", identifier=" + this.getIdentifier() + "}";
    }
}

