/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record TeamsPacket(String teamName, Action action) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final int MAX_MEMBERS = 16384;

    public TeamsPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), (Action)((Object)(switch (reader.read(NetworkBuffer.BYTE)) {
            case 0 -> new CreateTeamAction(reader);
            case 1 -> new RemoveTeamAction();
            case 2 -> new UpdateTeamAction(reader);
            case 3 -> new AddEntitiesToTeamAction(reader);
            case 4 -> new RemoveEntitiesToTeamAction(reader);
            default -> throw new RuntimeException("Unknown action id");
        })));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.teamName);
        writer.write(NetworkBuffer.BYTE, (byte)this.action.id());
        writer.write(this.action);
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        Collection<Component> collection;
        Action action = this.action;
        if (action instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action);
            collection = holder.components();
        } else {
            collection = List.of();
        }
        return collection;
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        Action action;
        Action action2 = this.action;
        if (action2 instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action2);
            action = (Action)holder.copyWithOperator(operator);
        } else {
            action = this.action;
        }
        return new TeamsPacket(this.teamName, action);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.TEAMS;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Action
    extends NetworkBuffer.Writer {
        public int id();
    }

    public record CreateTeamAction(Component displayName, byte friendlyFlags, NameTagVisibility nameTagVisibility, CollisionRule collisionRule, NamedTextColor teamColor, Component teamPrefix, Component teamSuffix, Collection<String> entities) implements Action,
    ComponentHolder<CreateTeamAction>
    {
        public CreateTeamAction {
            entities = List.copyOf(entities);
        }

        public CreateTeamAction(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.BYTE), NameTagVisibility.fromIdentifier(reader.read(NetworkBuffer.STRING)), CollisionRule.fromIdentifier(reader.read(NetworkBuffer.STRING)), NamedTextColor.namedColor((int)reader.read(NetworkBuffer.VAR_INT)), reader.read(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.COMPONENT), reader.readCollection(NetworkBuffer.STRING, 16384));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.COMPONENT, this.displayName);
            writer.write(NetworkBuffer.BYTE, this.friendlyFlags);
            writer.write(NetworkBuffer.STRING, this.nameTagVisibility.getIdentifier());
            writer.write(NetworkBuffer.STRING, this.collisionRule.getIdentifier());
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getNamedTextColorValue(this.teamColor));
            writer.write(NetworkBuffer.COMPONENT, this.teamPrefix);
            writer.write(NetworkBuffer.COMPONENT, this.teamSuffix);
            writer.writeCollection(NetworkBuffer.STRING, this.entities);
        }

        @Override
        public int id() {
            return 0;
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.displayName, this.teamPrefix, this.teamSuffix);
        }

        @Override
        @NotNull
        public CreateTeamAction copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new CreateTeamAction((Component)operator.apply(this.displayName), this.friendlyFlags, this.nameTagVisibility, this.collisionRule, this.teamColor, (Component)operator.apply(this.teamPrefix), (Component)operator.apply(this.teamSuffix), this.entities);
        }
    }

    public record RemoveTeamAction() implements Action
    {
        @Override
        public void write(@NotNull NetworkBuffer writer) {
        }

        @Override
        public int id() {
            return 1;
        }
    }

    public record UpdateTeamAction(Component displayName, byte friendlyFlags, NameTagVisibility nameTagVisibility, CollisionRule collisionRule, NamedTextColor teamColor, Component teamPrefix, Component teamSuffix) implements Action,
    ComponentHolder<UpdateTeamAction>
    {
        public UpdateTeamAction(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.BYTE), NameTagVisibility.fromIdentifier(reader.read(NetworkBuffer.STRING)), CollisionRule.fromIdentifier(reader.read(NetworkBuffer.STRING)), NamedTextColor.namedColor((int)reader.read(NetworkBuffer.VAR_INT)), reader.read(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.COMPONENT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.COMPONENT, this.displayName);
            writer.write(NetworkBuffer.BYTE, this.friendlyFlags);
            writer.write(NetworkBuffer.STRING, this.nameTagVisibility.getIdentifier());
            writer.write(NetworkBuffer.STRING, this.collisionRule.getIdentifier());
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getNamedTextColorValue(this.teamColor));
            writer.write(NetworkBuffer.COMPONENT, this.teamPrefix);
            writer.write(NetworkBuffer.COMPONENT, this.teamSuffix);
        }

        @Override
        public int id() {
            return 2;
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.displayName, this.teamPrefix, this.teamSuffix);
        }

        @Override
        @NotNull
        public UpdateTeamAction copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new UpdateTeamAction((Component)operator.apply(this.displayName), this.friendlyFlags, this.nameTagVisibility, this.collisionRule, this.teamColor, (Component)operator.apply(this.teamPrefix), (Component)operator.apply(this.teamSuffix));
        }
    }

    public record AddEntitiesToTeamAction(@NotNull @NotNull Collection<@NotNull String> entities) implements Action
    {
        public AddEntitiesToTeamAction(@NotNull Collection<String> entities) {
            entities = List.copyOf(entities);
        }

        public AddEntitiesToTeamAction(@NotNull NetworkBuffer reader) {
            this(reader.readCollection(NetworkBuffer.STRING, 16384));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeCollection(NetworkBuffer.STRING, this.entities);
        }

        @Override
        public int id() {
            return 3;
        }
    }

    public record RemoveEntitiesToTeamAction(@NotNull @NotNull Collection<@NotNull String> entities) implements Action
    {
        public RemoveEntitiesToTeamAction(@NotNull Collection<String> entities) {
            entities = List.copyOf(entities);
        }

        public RemoveEntitiesToTeamAction(@NotNull NetworkBuffer reader) {
            this(reader.readCollection(NetworkBuffer.STRING, 16384));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeCollection(NetworkBuffer.STRING, this.entities);
        }

        @Override
        public int id() {
            return 4;
        }
    }

    public static enum CollisionRule {
        ALWAYS("always"),
        PUSH_OTHER_TEAMS("pushOtherTeams"),
        PUSH_OWN_TEAM("pushOwnTeam"),
        NEVER("never");

        private final String identifier;

        private CollisionRule(String identifier) {
            this.identifier = identifier;
        }

        @NotNull
        public static CollisionRule fromIdentifier(String identifier) {
            for (CollisionRule v : CollisionRule.values()) {
                if (!v.getIdentifier().equals(identifier)) continue;
                return v;
            }
            Check.fail("Identifier for CollisionRule is invalid: " + identifier);
            return null;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum NameTagVisibility {
        ALWAYS("always"),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams"),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam"),
        NEVER("never");

        private final String identifier;

        private NameTagVisibility(String identifier) {
            this.identifier = identifier;
        }

        @NotNull
        public static NameTagVisibility fromIdentifier(String identifier) {
            for (NameTagVisibility v : NameTagVisibility.values()) {
                if (!v.getIdentifier().equals(identifier)) continue;
                return v;
            }
            Check.fail("Identifier for NameTagVisibility is invalid: " + identifier);
            return null;
        }

        @NotNull
        public String getIdentifier() {
            return this.identifier;
        }
    }
}

