/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.metadata;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minestom.server.entity.PlayerSkin;
import net.minestom.server.item.ItemMetaView;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.tag.TagWritable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTType;

public record PlayerHeadMeta(TagReadable readable) implements ItemMetaView<Builder>
{
    public static final Tag<UUID> SKULL_OWNER = Tag.UUID("Id").path("SkullOwner");
    public static final Tag<PlayerSkin> SKIN = Tag.Structure("Properties", new TagSerializer<PlayerSkin>(){
        private static final Tag<NBT> TEXTURES = Tag.NBT("textures");

        @Override
        @Nullable
        public PlayerSkin read(@NotNull TagReadable reader) {
            NBT result = reader.getTag(TEXTURES);
            if (!(result instanceof NBTList)) {
                return null;
            }
            NBTList textures = (NBTList)result;
            NBTCompound texture = (NBTCompound)textures.get(0);
            String value = texture.getString("Value");
            String signature = texture.getString("Signature");
            return new PlayerSkin(value, signature);
        }

        @Override
        public void write(@NotNull TagWritable writer, @NotNull PlayerSkin playerSkin) {
            String value = Objects.requireNonNullElse(playerSkin.textures(), "");
            String signature = Objects.requireNonNullElse(playerSkin.signature(), "");
            NBTList textures = new NBTList(NBTType.TAG_Compound, List.of(NBT.Compound(Map.of("Value", NBT.String((String)value), "Signature", NBT.String((String)signature)))));
            writer.setTag(TEXTURES, textures);
        }
    }).path("SkullOwner");

    @Nullable
    public UUID getSkullOwner() {
        return this.getTag(SKULL_OWNER);
    }

    @Nullable
    public PlayerSkin getPlayerSkin() {
        return this.getTag(SKIN);
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.readable.getTag(tag);
    }

    public record Builder(TagHandler tagHandler) implements ItemMetaView.Builder
    {
        public Builder() {
            this(TagHandler.newHandler());
        }

        public Builder skullOwner(@Nullable UUID skullOwner) {
            this.setTag(SKULL_OWNER, skullOwner);
            return this;
        }

        public Builder playerSkin(@Nullable PlayerSkin playerSkin) {
            this.setTag(SKIN, playerSkin);
            return this;
        }
    }
}

