/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.metadata.projectile.ProjectileMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityShootEvent;
import net.minestom.server.event.entity.projectile.ProjectileCollideWithBlockEvent;
import net.minestom.server.event.entity.projectile.ProjectileCollideWithEntityEvent;
import net.minestom.server.event.entity.projectile.ProjectileUncollideEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityProjectile
extends Entity {
    private final Entity shooter;

    public EntityProjectile(@Nullable Entity shooter, @NotNull EntityType entityType) {
        super(entityType);
        this.shooter = shooter;
        this.setup();
    }

    private void setup() {
        this.hasPhysics = false;
        if (this.getEntityMeta() instanceof ProjectileMeta) {
            ((ProjectileMeta)((Object)this.getEntityMeta())).setShooter(this.shooter);
        }
    }

    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    public void shoot(Point to, double power, double spread) {
        EntityShootEvent shootEvent = new EntityShootEvent(this.shooter, this, to, power, spread);
        EventDispatcher.call(shootEvent);
        if (shootEvent.isCancelled()) {
            this.remove();
            return;
        }
        Pos from = this.shooter.getPosition().add(0.0, this.shooter.getEyeHeight(), 0.0);
        this.shoot(from, to, shootEvent.getPower(), shootEvent.getSpread());
    }

    private void shoot(@NotNull Point from, @NotNull Point to, double power, double spread) {
        double dx = to.x() - from.x();
        double dy = to.y() - from.y();
        double dz = to.z() - from.z();
        if (!this.hasNoGravity()) {
            double xzLength = Math.sqrt(dx * dx + dz * dz);
            dy += xzLength * (double)0.2f;
        }
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= length;
        dy /= length;
        dz /= length;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        double mul = 20.0 * power;
        this.velocity = new Vec((dx += random.nextGaussian() * (spread *= (double)0.0075f)) * mul, (dy += random.nextGaussian() * spread) * mul, (dz += random.nextGaussian() * spread) * mul);
        this.setView((float)Math.toDegrees(Math.atan2(dx, dz)), (float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))));
    }

    @Override
    public void tick(long time) {
        Pos posBefore = this.getPosition();
        super.tick(time);
        Pos posNow = this.getPosition();
        if (this.isStuck(posBefore, posNow)) {
            if (this.onGround) {
                return;
            }
            this.onGround = true;
            this.velocity = Vec.ZERO;
            this.sendPacketToViewersAndSelf(this.getVelocityPacket());
            this.setNoGravity(true);
        } else {
            if (!this.onGround) {
                return;
            }
            this.onGround = false;
            this.setNoGravity(false);
            EventDispatcher.call(new ProjectileUncollideEvent(this));
        }
    }

    private boolean isStuck(Pos pos, Pos posNow) {
        Instance instance = this.getInstance();
        if (pos.samePoint(posNow)) {
            return instance.getBlock(pos).isSolid();
        }
        Chunk chunk = null;
        Collection entities = null;
        BoundingBox bb = this.getBoundingBox();
        double part = bb.width() / 2.0;
        Vec dir = posNow.sub(pos).asVec();
        int parts = (int)Math.ceil(dir.length() / part);
        Pos direction = dir.normalize().mul(part).asPosition();
        long aliveTicks = this.getAliveTicks();
        Block block = null;
        Pos blockPos = null;
        for (int i = 0; i < parts; ++i) {
            Optional<LivingEntity> victimOptional;
            Pos pos2 = pos = i == parts - 1 ? posNow : pos.add(direction);
            if (block == null || !pos.sameBlock(blockPos)) {
                block = instance.getBlock(pos);
                blockPos = pos;
            }
            if (block.isSolid()) {
                ProjectileCollideWithBlockEvent event = new ProjectileCollideWithBlockEvent(this, pos, block);
                EventDispatcher.call(event);
                if (!event.isCancelled()) {
                    this.teleport(pos);
                    return true;
                }
            }
            if (this.currentChunk != chunk) {
                chunk = this.currentChunk;
                entities = instance.getChunkEntities(chunk).stream().filter(entity -> entity instanceof LivingEntity).map(entity -> (LivingEntity)entity).collect(Collectors.toSet());
            }
            Pos currentPos = pos;
            Stream<LivingEntity> victimsStream = entities.stream().filter(entity -> bb.intersectEntity(currentPos, (Entity)entity));
            if (aliveTicks < 3L && this.shooter != null) {
                victimsStream = victimsStream.filter(entity -> entity != this.shooter);
            }
            if (!(victimOptional = victimsStream.findAny()).isPresent()) continue;
            LivingEntity target = victimOptional.get();
            ProjectileCollideWithEntityEvent event = new ProjectileCollideWithEntityEvent(this, pos, target);
            EventDispatcher.call(event);
            if (event.isCancelled()) continue;
            return this.onGround;
        }
        return false;
    }
}

