/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.common;

import net.minestom.server.entity.Player;
import net.minestom.server.message.ChatMessageType;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientSettingsPacket(@NotNull String locale, byte viewDistance, @NotNull ChatMessageType chatMessageType, boolean chatColors, byte displayedSkinParts, @NotNull Player.MainHand mainHand, boolean enableTextFiltering, boolean allowsListing) implements ClientPacket
{
    public ClientSettingsPacket(@NotNull String locale, byte viewDistance, @NotNull ChatMessageType chatMessageType, boolean chatColors, byte displayedSkinParts, @NotNull Player.MainHand mainHand, boolean enableTextFiltering, boolean allowsListing) {
        if (locale.length() > 128) {
            throw new IllegalArgumentException("Locale cannot be longer than 128 characters.");
        }
    }

    public ClientSettingsPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.BYTE), ChatMessageType.fromPacketID(reader.read(NetworkBuffer.VAR_INT)), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BYTE), reader.readEnum(Player.MainHand.class), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.locale);
        writer.write(NetworkBuffer.BYTE, this.viewDistance);
        writer.write(NetworkBuffer.VAR_INT, this.chatMessageType.getPacketID());
        writer.write(NetworkBuffer.BOOLEAN, this.chatColors);
        writer.write(NetworkBuffer.BYTE, this.displayedSkinParts);
        writer.write(NetworkBuffer.VAR_INT, this.mainHand.ordinal());
        writer.write(NetworkBuffer.BOOLEAN, this.enableTextFiltering);
        writer.write(NetworkBuffer.BOOLEAN, this.allowsListing);
    }
}

