/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.data.WorldPos;
import net.minestom.server.particle.Particle;
import net.minestom.server.particle.data.ParticleData;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.CompressedProcesser;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTEnd;
import org.jglrxavpok.hephaistos.nbt.NBTException;
import org.jglrxavpok.hephaistos.nbt.NBTReader;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.NBTWriter;

interface NetworkBufferTypeImpl<T>
extends NetworkBuffer.Type<T> {
    public static final int SEGMENT_BITS = 127;
    public static final int CONTINUE_BIT = 128;

    public static <T extends Enum<?>> NetworkBufferTypeImpl<T> fromEnum(final Class<T> enumClass) {
        return new NetworkBufferTypeImpl<T>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, T value) {
                buffer.writeEnum(enumClass, value);
            }

            @Override
            public T read(@NotNull NetworkBuffer buffer) {
                return buffer.readEnum(enumClass);
            }
        };
    }

    public static <T> NetworkBufferTypeImpl<T> fromOptional(final NetworkBuffer.Type<T> optionalType) {
        return new NetworkBufferTypeImpl<T>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, T value) {
                buffer.writeOptional(optionalType, value);
            }

            @Override
            public T read(@NotNull NetworkBuffer buffer) {
                return buffer.readOptional(optionalType);
            }
        };
    }

    public record ParticleType() implements NetworkBufferTypeImpl<Particle>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Particle value) {
            Check.stateCondition(value.data() != null && !value.data().validate(value.id()), "Particle data {0} is not valid for this particle type {1}", value.data(), value.namespace());
            Check.stateCondition(value.data() == null && ParticleData.requiresData(value.id()), "Particle data is required for this particle type {0}", value.namespace());
            buffer.write(NetworkBuffer.VAR_INT, value.id());
            if (value.data() != null) {
                value.data().write(buffer);
            }
        }

        @Override
        public Particle read(@NotNull NetworkBuffer buffer) {
            throw new UnsupportedOperationException("Cannot read a particle from the network buffer");
        }
    }

    public record QuaternionType() implements NetworkBufferTypeImpl<float[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, float[] value) {
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[0]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[1]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[2]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[3]));
        }

        @Override
        public float[] read(@NotNull NetworkBuffer buffer) {
            float x = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float y = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float z = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float w = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new float[]{x, y, z, w};
        }
    }

    public record Vector3DType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.DOUBLE, value.x());
            buffer.write(NetworkBuffer.DOUBLE, value.y());
            buffer.write(NetworkBuffer.DOUBLE, value.z());
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            double x = buffer.read(NetworkBuffer.DOUBLE);
            double y = buffer.read(NetworkBuffer.DOUBLE);
            double z = buffer.read(NetworkBuffer.DOUBLE);
            return new Vec(x, y, z);
        }
    }

    public record Vector3Type() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.x()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.y()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.z()));
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            float x = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float y = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float z = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new Vec(x, y, z);
        }
    }

    public record DeathLocationType() implements NetworkBufferTypeImpl<WorldPos>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, WorldPos value) {
            buffer.writeOptional(value);
        }

        @Override
        public WorldPos read(@NotNull NetworkBuffer buffer) {
            return buffer.readOptional(WorldPos::new);
        }
    }

    public record VillagerDataType() implements NetworkBufferTypeImpl<int[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, int[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value[0]);
            buffer.write(NetworkBuffer.VAR_INT, value[1]);
            buffer.write(NetworkBuffer.VAR_INT, value[2]);
        }

        @Override
        public int[] read(@NotNull NetworkBuffer buffer) {
            int[] value = new int[]{buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.VAR_INT)};
            return value;
        }
    }

    public record BlockStateType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.write(NetworkBuffer.VAR_INT, value);
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            return buffer.read(NetworkBuffer.VAR_INT);
        }
    }

    public record VarLongArrayType() implements NetworkBufferTypeImpl<long[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, long[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (long l : value) {
                buffer.write(NetworkBuffer.VAR_LONG, l);
            }
        }

        @Override
        public long[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = buffer.read(NetworkBuffer.VAR_LONG);
            }
            return longs;
        }
    }

    public record VarIntArrayType() implements NetworkBufferTypeImpl<int[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, int[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (int i : value) {
                buffer.write(NetworkBuffer.VAR_INT, i);
            }
        }

        @Override
        public int[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            int[] ints = new int[length];
            for (int i = 0; i < length; ++i) {
                ints[i] = buffer.read(NetworkBuffer.VAR_INT);
            }
            return ints;
        }
    }

    public record LongArrayType() implements NetworkBufferTypeImpl<long[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, long[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (long l : value) {
                buffer.write(NetworkBuffer.LONG, l);
            }
        }

        @Override
        public long[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = buffer.read(NetworkBuffer.LONG);
            }
            return longs;
        }
    }

    public record ByteArrayType() implements NetworkBufferTypeImpl<byte[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, byte[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            buffer.write(NetworkBuffer.RAW_BYTES, value);
        }

        @Override
        public byte[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            byte[] bytes = new byte[length];
            buffer.nioBuffer.get(buffer.readIndex(), bytes);
            buffer.readIndex += length;
            return bytes;
        }
    }

    public record ItemType() implements NetworkBufferTypeImpl<ItemStack>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, ItemStack value) {
            if (value.isAir()) {
                buffer.write(NetworkBuffer.BOOLEAN, false);
                return;
            }
            buffer.write(NetworkBuffer.BOOLEAN, true);
            buffer.write(NetworkBuffer.VAR_INT, value.material().id());
            buffer.write(NetworkBuffer.BYTE, (byte)value.amount());
            NBTCompound nbt = value.meta().toNBT();
            buffer.write(NetworkBuffer.NBT, nbt.isEmpty() ? NBTEnd.INSTANCE : nbt);
        }

        @Override
        public ItemStack read(@NotNull NetworkBuffer buffer) {
            boolean present = buffer.read(NetworkBuffer.BOOLEAN);
            if (!present) {
                return ItemStack.AIR;
            }
            int id = buffer.read(NetworkBuffer.VAR_INT);
            Material material = Material.fromId(id);
            if (material == null) {
                throw new RuntimeException("Unknown material id: " + id);
            }
            byte amount = buffer.read(NetworkBuffer.BYTE);
            NBT nbt = buffer.read(NetworkBuffer.NBT);
            if (!(nbt instanceof NBTCompound)) {
                return ItemStack.of(material, amount);
            }
            NBTCompound compound = (NBTCompound)nbt;
            return ItemStack.fromNBT(material, compound, amount);
        }
    }

    public record UUIDType() implements NetworkBufferTypeImpl<UUID>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, UUID value) {
            buffer.write(NetworkBuffer.LONG, value.getMostSignificantBits());
            buffer.write(NetworkBuffer.LONG, value.getLeastSignificantBits());
        }

        @Override
        public UUID read(@NotNull NetworkBuffer buffer) {
            long mostSignificantBits = buffer.read(NetworkBuffer.LONG);
            long leastSignificantBits = buffer.read(NetworkBuffer.LONG);
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
    }

    public record JsonComponentType() implements NetworkBufferTypeImpl<Component>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Component value) {
            String json = (String)GsonComponentSerializer.gson().serialize(value);
            buffer.write(NetworkBuffer.STRING, json);
        }

        @Override
        public Component read(@NotNull NetworkBuffer buffer) {
            String json = buffer.read(NetworkBuffer.STRING);
            return GsonComponentSerializer.gson().deserialize((Object)json);
        }
    }

    public record ComponentType() implements NetworkBufferTypeImpl<Component>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Component value) {
            NBT nbt = (NBT)NbtComponentSerializer.nbt().serialize(value);
            buffer.write(NetworkBuffer.NBT, nbt);
        }

        @Override
        public Component read(@NotNull NetworkBuffer buffer) {
            NBT nbt = buffer.read(NetworkBuffer.NBT);
            return NbtComponentSerializer.nbt().deserialize(nbt);
        }
    }

    public record BlockPositionType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            int blockX = value.blockX();
            int blockY = value.blockY();
            int blockZ = value.blockZ();
            long longPos = ((long)blockX & 0x3FFFFFFL) << 38 | ((long)blockZ & 0x3FFFFFFL) << 12 | (long)blockY & 0xFFFL;
            buffer.write(NetworkBuffer.LONG, longPos);
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            long value = buffer.read(NetworkBuffer.LONG);
            int x = (int)(value >> 38);
            int y = (int)(value << 52 >> 52);
            int z = (int)(value << 26 >> 38);
            return new Vec(x, y, z);
        }
    }

    public record NbtType() implements NetworkBufferTypeImpl<NBT>
    {
        @Override
        public void write(final @NotNull NetworkBuffer buffer, NBT value) {
            NBTWriter nbtWriter = buffer.nbtWriter;
            if (nbtWriter == null) {
                buffer.nbtWriter = nbtWriter = new NBTWriter(new OutputStream(this){

                    @Override
                    public void write(int b) {
                        buffer.write(NetworkBuffer.BYTE, (byte)b);
                    }
                }, CompressedProcesser.NONE);
            }
            try {
                if (value == NBTEnd.INSTANCE) {
                    buffer.write(NetworkBuffer.BYTE, (byte)NBTType.TAG_End.getOrdinal());
                } else {
                    buffer.write(NetworkBuffer.BYTE, (byte)value.getID().getOrdinal());
                    nbtWriter.writeRaw(value);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public NBT read(final @NotNull NetworkBuffer buffer) {
            NBTReader nbtReader = buffer.nbtReader;
            if (nbtReader == null) {
                buffer.nbtReader = nbtReader = new NBTReader(new InputStream(this){

                    @Override
                    public int read() {
                        return buffer.read(NetworkBuffer.BYTE) & 0xFF;
                    }

                    @Override
                    public int available() {
                        return buffer.readableBytes();
                    }
                }, CompressedProcesser.NONE);
            }
            try {
                byte tagId = buffer.read(NetworkBuffer.BYTE);
                if (tagId == NBTType.TAG_End.getOrdinal()) {
                    return NBTEnd.INSTANCE;
                }
                return nbtReader.readRaw((int)tagId);
            }
            catch (IOException | NBTException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public record StringType() implements NetworkBufferTypeImpl<String>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            buffer.write(NetworkBuffer.VAR_INT, bytes.length);
            buffer.write(NetworkBuffer.RAW_BYTES, bytes);
        }

        @Override
        public String read(@NotNull NetworkBuffer buffer) {
            int remaining;
            int length = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition(length > (remaining = buffer.nioBuffer.limit() - buffer.readIndex()), "String is too long (length: {0}, readable: {1})", length, remaining);
            byte[] bytes = new byte[length];
            buffer.nioBuffer.get(buffer.readIndex(), bytes);
            buffer.readIndex += length;
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    public record RawBytesType() implements NetworkBufferTypeImpl<byte[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, byte[] value) {
            buffer.ensureSize(value.length);
            buffer.nioBuffer.put(buffer.writeIndex(), value);
            buffer.writeIndex += value.length;
        }

        @Override
        public byte[] read(@NotNull NetworkBuffer buffer) {
            int limit = buffer.nioBuffer.limit();
            int length = limit - buffer.readIndex();
            assert (length > 0) : "Invalid remaining: " + length;
            byte[] bytes = new byte[length];
            buffer.nioBuffer.get(buffer.readIndex(), bytes);
            buffer.readIndex += length;
            return bytes;
        }
    }

    public record VarLongType() implements NetworkBufferTypeImpl<Long>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Long value) {
            buffer.ensureSize(10);
            int size = 0;
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    buffer.nioBuffer.put(buffer.writeIndex() + size, (byte)value.intValue());
                    buffer.writeIndex += size + 1;
                    return;
                }
                buffer.nioBuffer.put(buffer.writeIndex() + size, (byte)(value & 0x7FL | 0x80L));
                ++size;
                value = value >>> 7;
            }
        }

        @Override
        public Long read(@NotNull NetworkBuffer buffer) {
            long value;
            int length;
            block1: {
                length = 0;
                value = 0L;
                int position = 0;
                do {
                    byte currentByte = buffer.nioBuffer.get(buffer.readIndex() + length);
                    ++length;
                    value |= (long)(currentByte & 0x7F) << position;
                    if ((currentByte & 0x80) == 0) break block1;
                } while ((position += 7) < 64);
                throw new RuntimeException("VarLong is too big");
            }
            buffer.readIndex += length;
            return value;
        }
    }

    public record VarIntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer boxed) {
            int value = boxed;
            int index = buffer.writeIndex();
            if ((value & 0xFFFFFF80) == 0) {
                buffer.ensureSize(1);
                buffer.nioBuffer.put(index, (byte)value);
                ++buffer.writeIndex;
            } else if ((value & 0xFFFFC000) == 0) {
                buffer.ensureSize(2);
                buffer.nioBuffer.putShort(index, (short)((value & 0x7F | 0x80) << 8 | value >>> 7));
                buffer.writeIndex += 2;
            } else if ((value & 0xFFE00000) == 0) {
                buffer.ensureSize(3);
                ByteBuffer nio = buffer.nioBuffer;
                nio.put(index, (byte)(value & 0x7F | 0x80));
                nio.put(index + 1, (byte)(value >>> 7 & 0x7F | 0x80));
                nio.put(index + 2, (byte)(value >>> 14));
                buffer.writeIndex += 3;
            } else if ((value & 0xF0000000) == 0) {
                buffer.ensureSize(4);
                ByteBuffer nio = buffer.nioBuffer;
                nio.putInt(index, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21);
                buffer.writeIndex += 4;
            } else {
                buffer.ensureSize(5);
                ByteBuffer nio = buffer.nioBuffer;
                nio.putInt(index, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
                nio.put(index + 4, (byte)(value >>> 28));
                buffer.writeIndex += 5;
            }
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            int index = buffer.readIndex();
            int result = 0;
            int shift = 0;
            while (true) {
                byte b = buffer.nioBuffer.get(index++);
                result |= (b & 0x7F) << shift;
                if (b >= 0) {
                    buffer.readIndex += index - buffer.readIndex();
                    return result;
                }
                shift += 7;
            }
        }
    }

    public record DoubleType() implements NetworkBufferTypeImpl<Double>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Double value) {
            buffer.ensureSize(8);
            buffer.nioBuffer.putDouble(buffer.writeIndex(), value);
            buffer.writeIndex += 8;
        }

        @Override
        public Double read(@NotNull NetworkBuffer buffer) {
            double value = buffer.nioBuffer.getDouble(buffer.readIndex());
            buffer.readIndex += 8;
            return value;
        }
    }

    public record FloatType() implements NetworkBufferTypeImpl<Float>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Float value) {
            buffer.ensureSize(4);
            buffer.nioBuffer.putFloat(buffer.writeIndex(), value.floatValue());
            buffer.writeIndex += 4;
        }

        @Override
        public Float read(@NotNull NetworkBuffer buffer) {
            float value = buffer.nioBuffer.getFloat(buffer.readIndex());
            buffer.readIndex += 4;
            return Float.valueOf(value);
        }
    }

    public record LongType() implements NetworkBufferTypeImpl<Long>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Long value) {
            buffer.ensureSize(8);
            buffer.nioBuffer.putLong(buffer.writeIndex(), value);
            buffer.writeIndex += 8;
        }

        @Override
        public Long read(@NotNull NetworkBuffer buffer) {
            long value = buffer.nioBuffer.getLong(buffer.readIndex());
            buffer.readIndex += 8;
            return value;
        }
    }

    public record IntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.ensureSize(4);
            buffer.nioBuffer.putInt(buffer.writeIndex(), value);
            buffer.writeIndex += 4;
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            int value = buffer.nioBuffer.getInt(buffer.readIndex());
            buffer.readIndex += 4;
            return value;
        }
    }

    public record UnsignedShortType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.ensureSize(2);
            buffer.nioBuffer.putShort(buffer.writeIndex(), (short)(value & 0xFFFF));
            buffer.writeIndex += 2;
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            short value = buffer.nioBuffer.getShort(buffer.readIndex());
            buffer.readIndex += 2;
            return value & 0xFFFF;
        }
    }

    public record ShortType() implements NetworkBufferTypeImpl<Short>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Short value) {
            buffer.ensureSize(2);
            buffer.nioBuffer.putShort(buffer.writeIndex(), value);
            buffer.writeIndex += 2;
        }

        @Override
        public Short read(@NotNull NetworkBuffer buffer) {
            short value = buffer.nioBuffer.getShort(buffer.readIndex());
            buffer.readIndex += 2;
            return value;
        }
    }

    public record ByteType() implements NetworkBufferTypeImpl<Byte>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Byte value) {
            buffer.ensureSize(1);
            buffer.nioBuffer.put(buffer.writeIndex(), value);
            ++buffer.writeIndex;
        }

        @Override
        public Byte read(@NotNull NetworkBuffer buffer) {
            byte value = buffer.nioBuffer.get(buffer.readIndex());
            ++buffer.readIndex;
            return value;
        }
    }

    public record BooleanType() implements NetworkBufferTypeImpl<Boolean>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Boolean value) {
            buffer.ensureSize(1);
            buffer.nioBuffer.put(buffer.writeIndex(), value != false ? (byte)1 : 0);
            ++buffer.writeIndex;
        }

        @Override
        public Boolean read(@NotNull NetworkBuffer buffer) {
            byte value = buffer.nioBuffer.get(buffer.readIndex());
            ++buffer.readIndex;
            return value == 1;
        }
    }
}

