/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map.framebuffers;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minestom.server.map.Framebuffer;
import net.minestom.server.map.MapColors;

public class Graphics2DFramebuffer
implements Framebuffer {
    private final byte[] colors = new byte[16384];
    private final BufferedImage backingImage = new BufferedImage(128, 128, 1);
    private final Graphics2D renderer = this.backingImage.createGraphics();
    private final int[] pixels = ((DataBufferInt)this.backingImage.getRaster().getDataBuffer()).getData();

    public Graphics2D getRenderer() {
        return this.renderer;
    }

    public BufferedImage getBackingImage() {
        return this.backingImage;
    }

    public int get(int x, int z) {
        return this.pixels[x + z * 128];
    }

    public Graphics2DFramebuffer set(int x, int z, int rgb) {
        this.pixels[x + z * 128] = rgb;
        return this;
    }

    @Override
    public byte[] toMapColors() {
        for (int x = 0; x < 128; ++x) {
            for (int z = 0; z < 128; ++z) {
                this.colors[Framebuffer.index((int)x, (int)z)] = MapColors.closestColor(this.get(x, z)).getIndex();
            }
        }
        return this.colors;
    }
}

