/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minestom.server.ServerFlag;
import net.minestom.server.Viewable;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import space.vectrix.flare.fastutil.Int2ObjectSyncMap;
import space.vectrix.flare.fastutil.Long2ObjectSyncMap;

final class EntityTrackerImpl
implements EntityTracker {
    static final AtomicInteger TARGET_COUNTER = new AtomicInteger();
    final TargetEntry<Entity>[] entries = (TargetEntry[])EntityTracker.Target.TARGETS.stream().map(TargetEntry::new).toArray(TargetEntry[]::new);
    private final Int2ObjectSyncMap<Point> entityPositions = Int2ObjectSyncMap.hashmap();

    EntityTrackerImpl() {
    }

    @Override
    public <T extends Entity> void register(@NotNull Entity entity, @NotNull Point point, @NotNull EntityTracker.Target<T> target, @Nullable EntityTracker.Update<T> update) {
        Point prevPoint = (Point)this.entityPositions.putIfAbsent(entity.getEntityId(), (Object)point);
        if (prevPoint != null) {
            return;
        }
        long index = ChunkUtils.getChunkIndex(point);
        for (TargetEntry<Entity> entry : this.entries) {
            if (!entry.target.type().isInstance(entity)) continue;
            entry.entities.add(entity);
            entry.addToChunk(index, entity);
        }
        if (update != null) {
            update.referenceUpdate(point, this);
            this.nearbyEntitiesByChunkRange(point, ServerFlag.ENTITY_VIEW_DISTANCE, target, newEntity -> {
                if (newEntity == entity) {
                    return;
                }
                update.add(newEntity);
            });
        }
    }

    @Override
    public <T extends Entity> void unregister(@NotNull Entity entity, @NotNull EntityTracker.Target<T> target, @Nullable EntityTracker.Update<T> update) {
        Point point = (Point)this.entityPositions.remove(entity.getEntityId());
        if (point == null) {
            return;
        }
        long index = ChunkUtils.getChunkIndex(point);
        for (TargetEntry<Entity> entry : this.entries) {
            if (!entry.target.type().isInstance(entity)) continue;
            entry.entities.remove(entity);
            entry.removeFromChunk(index, entity);
        }
        if (update != null) {
            update.referenceUpdate(point, null);
            this.nearbyEntitiesByChunkRange(point, ServerFlag.ENTITY_VIEW_DISTANCE, target, newEntity -> {
                if (newEntity == entity) {
                    return;
                }
                update.remove(newEntity);
            });
        }
    }

    @Override
    public <T extends Entity> void move(final @NotNull Entity entity, @NotNull Point newPoint, @NotNull EntityTracker.Target<T> target, final @Nullable EntityTracker.Update<T> update) {
        Point oldPoint = (Point)this.entityPositions.put(entity.getEntityId(), (Object)newPoint);
        if (oldPoint == null || oldPoint.sameChunk(newPoint)) {
            return;
        }
        long oldIndex = ChunkUtils.getChunkIndex(oldPoint);
        long newIndex = ChunkUtils.getChunkIndex(newPoint);
        for (TargetEntry<Entity> entry : this.entries) {
            if (!entry.target.type().isInstance(entity)) continue;
            entry.addToChunk(newIndex, entity);
            entry.removeFromChunk(oldIndex, entity);
        }
        if (update != null) {
            this.difference(oldPoint, newPoint, target, new EntityTracker.Update<T>(this){

                @Override
                public void add(@NotNull T added) {
                    if (entity != added) {
                        update.add(added);
                    }
                }

                @Override
                public void remove(@NotNull T removed) {
                    if (entity != removed) {
                        update.remove(removed);
                    }
                }
            });
            update.referenceUpdate(newPoint, this);
        }
    }

    @Override
    public <T extends Entity> @Unmodifiable Collection<T> chunkEntities(int chunkX, int chunkZ, @NotNull EntityTracker.Target<T> target) {
        TargetEntry<Entity> entry = this.entries[target.ordinal()];
        List<Entity> chunkEntities = entry.chunkEntities(ChunkUtils.getChunkIndex(chunkX, chunkZ));
        return Collections.unmodifiableList(chunkEntities);
    }

    @Override
    public <T extends Entity> void nearbyEntitiesByChunkRange(@NotNull Point point, int chunkRange, @NotNull EntityTracker.Target<T> target, @NotNull Consumer<T> query) {
        Long2ObjectSyncMap entities = this.entries[target.ordinal()].chunkEntities;
        if (chunkRange == 0) {
            List chunkEntities = (List)entities.get(ChunkUtils.getChunkIndex(point));
            if (chunkEntities != null && !chunkEntities.isEmpty()) {
                chunkEntities.forEach(query);
            }
        } else {
            ChunkUtils.forChunksInRange(point, chunkRange, (chunkX, chunkZ) -> {
                List chunkEntities = (List)entities.get(ChunkUtils.getChunkIndex(chunkX, chunkZ));
                if (chunkEntities == null || chunkEntities.isEmpty()) {
                    return;
                }
                chunkEntities.forEach(query);
            });
        }
    }

    @Override
    public <T extends Entity> void nearbyEntities(@NotNull Point point, double range, @NotNull EntityTracker.Target<T> target, @NotNull Consumer<T> query) {
        Long2ObjectSyncMap entities = this.entries[target.ordinal()].chunkEntities;
        int minChunkX = ChunkUtils.getChunkCoordinate(point.x() - range);
        int minChunkZ = ChunkUtils.getChunkCoordinate(point.z() - range);
        int maxChunkX = ChunkUtils.getChunkCoordinate(point.x() + range);
        int maxChunkZ = ChunkUtils.getChunkCoordinate(point.z() + range);
        double squaredRange = range * range;
        if (minChunkX == maxChunkX && minChunkZ == maxChunkZ) {
            List chunkEntities = (List)entities.get(ChunkUtils.getChunkIndex(point));
            if (chunkEntities != null && !chunkEntities.isEmpty()) {
                chunkEntities.forEach(entity -> {
                    Point position = (Point)this.entityPositions.get(entity.getEntityId());
                    if (point.distanceSquared(position) <= squaredRange) {
                        query.accept(entity);
                    }
                });
            }
        } else {
            int chunkRange = (int)(range / 16.0) + 1;
            ChunkUtils.forChunksInRange(point, chunkRange, (chunkX, chunkZ) -> {
                List chunkEntities = (List)entities.get(ChunkUtils.getChunkIndex(chunkX, chunkZ));
                if (chunkEntities == null || chunkEntities.isEmpty()) {
                    return;
                }
                chunkEntities.forEach(entity -> {
                    Point position = (Point)this.entityPositions.get(entity.getEntityId());
                    if (point.distanceSquared(position) <= squaredRange) {
                        query.accept(entity);
                    }
                });
            });
        }
    }

    @Override
    @NotNull
    public <T extends Entity> @UnmodifiableView @NotNull Set<@NotNull T> entities(@NotNull EntityTracker.Target<T> target) {
        return this.entries[target.ordinal()].entitiesView;
    }

    @Override
    @NotNull
    public Viewable viewable(@NotNull @NotNull List<@NotNull SharedInstance> sharedInstances, int chunkX, int chunkZ) {
        TargetEntry<Entity> entry = this.entries[EntityTracker.Target.PLAYERS.ordinal()];
        return entry.viewers.computeIfAbsent(new ChunkViewKey(sharedInstances, chunkX, chunkZ), x$0 -> new ChunkView((ChunkViewKey)x$0));
    }

    private <T extends Entity> void difference(Point oldPoint, Point newPoint, @NotNull EntityTracker.Target<T> target, @NotNull EntityTracker.Update<T> update) {
        TargetEntry<Entity> entry = this.entries[target.ordinal()];
        ChunkUtils.forDifferingChunksInRange(newPoint.chunkX(), newPoint.chunkZ(), oldPoint.chunkX(), oldPoint.chunkZ(), ServerFlag.ENTITY_VIEW_DISTANCE, (chunkX, chunkZ) -> {
            List entities = (List)entry.chunkEntities.get(ChunkUtils.getChunkIndex(chunkX, chunkZ));
            if (entities == null || entities.isEmpty()) {
                return;
            }
            for (Entity entity : entities) {
                update.add(entity);
            }
        }, (chunkX, chunkZ) -> {
            List entities = (List)entry.chunkEntities.get(ChunkUtils.getChunkIndex(chunkX, chunkZ));
            if (entities == null || entities.isEmpty()) {
                return;
            }
            for (Entity entity : entities) {
                update.remove(entity);
            }
        });
    }

    static final class TargetEntry<T extends Entity> {
        private final EntityTracker.Target<T> target;
        private final Set<T> entities = ConcurrentHashMap.newKeySet();
        private final Set<T> entitiesView = Collections.unmodifiableSet(this.entities);
        final Long2ObjectSyncMap<List<T>> chunkEntities = Long2ObjectSyncMap.hashmap();
        final Map<ChunkViewKey, ChunkView> viewers = new ConcurrentHashMap<ChunkViewKey, ChunkView>();

        TargetEntry(EntityTracker.Target<T> target) {
            this.target = target;
        }

        List<T> chunkEntities(long index) {
            return (List)this.chunkEntities.computeIfAbsent(index, i -> new CopyOnWriteArrayList());
        }

        void addToChunk(long index, T entity) {
            this.chunkEntities(index).add(entity);
        }

        void removeFromChunk(long index, T entity) {
            List entities = (List)this.chunkEntities.get(index);
            if (entities != null) {
                entities.remove(entity);
            }
        }
    }

    record ChunkViewKey(List<SharedInstance> sharedInstances, int chunkX, int chunkZ) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChunkViewKey)) {
                return false;
            }
            ChunkViewKey key = (ChunkViewKey)obj;
            return this.sharedInstances == key.sharedInstances && this.chunkX == key.chunkX && this.chunkZ == key.chunkZ;
        }
    }

    private final class ChunkView
    implements Viewable {
        private final ChunkViewKey key;
        private final int chunkX;
        private final int chunkZ;
        private final Point point;
        final Set<Player> set = new SetImpl();
        private int lastReferenceCount;

        private ChunkView(ChunkViewKey key) {
            this.key = key;
            this.chunkX = key.chunkX;
            this.chunkZ = key.chunkZ;
            this.point = new Vec(16 * this.chunkX, 0.0, 16 * this.chunkZ);
        }

        @Override
        public boolean addViewer(@NotNull Player player) {
            throw new UnsupportedOperationException("Chunk does not support manual viewers");
        }

        @Override
        public boolean removeViewer(@NotNull Player player) {
            throw new UnsupportedOperationException("Chunk does not support manual viewers");
        }

        @Override
        @NotNull
        public @NotNull Set<@NotNull Player> getViewers() {
            return this.set;
        }

        private Collection<Player> references() {
            Int2ObjectOpenHashMap entityMap = new Int2ObjectOpenHashMap(this.lastReferenceCount);
            this.collectPlayers(EntityTrackerImpl.this, (Int2ObjectOpenHashMap<Player>)entityMap);
            if (!this.key.sharedInstances.isEmpty()) {
                for (SharedInstance instance : this.key.sharedInstances) {
                    this.collectPlayers(instance.getEntityTracker(), (Int2ObjectOpenHashMap<Player>)entityMap);
                }
            }
            this.lastReferenceCount = entityMap.size();
            return entityMap.values();
        }

        private void collectPlayers(EntityTracker tracker, Int2ObjectOpenHashMap<Player> map) {
            tracker.nearbyEntitiesByChunkRange(this.point, ServerFlag.CHUNK_VIEW_DISTANCE, EntityTracker.Target.PLAYERS, player -> map.putIfAbsent(player.getEntityId(), player));
        }

        final class SetImpl
        extends AbstractSet<Player> {
            SetImpl() {
            }

            @Override
            @NotNull
            public Iterator<Player> iterator() {
                return ChunkView.this.references().iterator();
            }

            @Override
            public int size() {
                return ChunkView.this.references().size();
            }

            @Override
            public void forEach(Consumer<? super Player> action) {
                ChunkView.this.references().forEach(action);
            }
        }
    }
}

