/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.monster;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.monster.MonsterMeta;
import org.jetbrains.annotations.NotNull;

public class CreeperMeta
extends MonsterMeta {
    public static final byte OFFSET = 16;
    public static final byte MAX_OFFSET = 19;

    public CreeperMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    @NotNull
    public State getState() {
        int id = this.metadata.getIndex(16, -1);
        return id == -1 ? State.IDLE : State.FUSE;
    }

    public void setState(@NotNull State value) {
        this.metadata.setIndex(16, Metadata.VarInt(value == State.IDLE ? -1 : 1));
    }

    public boolean isCharged() {
        return this.metadata.getIndex(17, false);
    }

    public void setCharged(boolean value) {
        this.metadata.setIndex(17, Metadata.Boolean(value));
    }

    public boolean isIgnited() {
        return this.metadata.getIndex(18, false);
    }

    public void setIgnited(boolean value) {
        this.metadata.setIndex(18, Metadata.Boolean(value));
    }

    public static enum State {
        IDLE,
        FUSE;

    }
}

