/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataImpl;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.entity.metadata.other.PaintingMeta;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.EntityMetaDataPacket;
import net.minestom.server.particle.Particle;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBT;

public final class Metadata {
    public static final byte TYPE_BYTE = 0;
    public static final byte TYPE_VARINT = 1;
    public static final byte TYPE_LONG = 2;
    public static final byte TYPE_FLOAT = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_CHAT = 5;
    public static final byte TYPE_OPTCHAT = 6;
    public static final byte TYPE_SLOT = 7;
    public static final byte TYPE_BOOLEAN = 8;
    public static final byte TYPE_ROTATION = 9;
    public static final byte TYPE_POSITION = 10;
    public static final byte TYPE_OPTPOSITION = 11;
    public static final byte TYPE_DIRECTION = 12;
    public static final byte TYPE_OPTUUID = 13;
    public static final byte TYPE_BLOCKSTATE = 14;
    public static final byte TYPE_OPTBLOCKSTATE = 15;
    public static final byte TYPE_NBT = 16;
    public static final byte TYPE_PARTICLE = 17;
    public static final byte TYPE_VILLAGERDATA = 18;
    public static final byte TYPE_OPTVARINT = 19;
    public static final byte TYPE_POSE = 20;
    public static final byte TYPE_CAT_VARIANT = 21;
    public static final byte TYPE_FROG_VARIANT = 22;
    public static final byte TYPE_OPTGLOBALPOS = 23;
    public static final byte TYPE_PAINTINGVARIANT = 24;
    public static final byte TYPE_SNIFFER_STATE = 25;
    public static final byte TYPE_VECTOR3 = 26;
    public static final byte TYPE_QUATERNION = 27;
    private static final VarHandle NOTIFIED_CHANGES;
    private final Entity entity;
    private volatile Entry<?>[] entries = new Entry[0];
    private volatile Map<Integer, Entry<?>> entryMap = null;
    private volatile boolean notifyAboutChanges = true;
    private final Map<Integer, Entry<?>> notNotifiedChanges = new HashMap();

    public static Entry<Byte> Byte(byte value) {
        return new MetadataImpl.EntryImpl<Byte>(0, value, NetworkBuffer.BYTE);
    }

    public static Entry<Integer> VarInt(int value) {
        return new MetadataImpl.EntryImpl<Integer>(1, value, NetworkBuffer.VAR_INT);
    }

    public static Entry<Long> Long(long value) {
        return new MetadataImpl.EntryImpl<Long>(2, value, NetworkBuffer.VAR_LONG);
    }

    public static Entry<Float> Float(float value) {
        return new MetadataImpl.EntryImpl<Float>(3, Float.valueOf(value), NetworkBuffer.FLOAT);
    }

    public static Entry<String> String(@NotNull String value) {
        return new MetadataImpl.EntryImpl<String>(4, value, NetworkBuffer.STRING);
    }

    public static Entry<Component> Chat(@NotNull Component value) {
        return new MetadataImpl.EntryImpl<Component>(5, value, NetworkBuffer.COMPONENT);
    }

    public static Entry<Component> OptChat(@Nullable Component value) {
        return new MetadataImpl.EntryImpl<Component>(6, value, NetworkBuffer.OPT_CHAT);
    }

    public static Entry<ItemStack> Slot(@NotNull ItemStack value) {
        return new MetadataImpl.EntryImpl<ItemStack>(7, value, NetworkBuffer.ITEM);
    }

    public static Entry<Boolean> Boolean(boolean value) {
        return new MetadataImpl.EntryImpl<Boolean>(8, value, NetworkBuffer.BOOLEAN);
    }

    public static Entry<Point> Rotation(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(9, value, NetworkBuffer.VECTOR3);
    }

    public static Entry<Point> Position(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(10, value, NetworkBuffer.BLOCK_POSITION);
    }

    public static Entry<Point> OptPosition(@Nullable Point value) {
        return new MetadataImpl.EntryImpl<Point>(11, value, NetworkBuffer.OPT_BLOCK_POSITION);
    }

    public static Entry<Direction> Direction(@NotNull Direction value) {
        return new MetadataImpl.EntryImpl<Direction>(12, value, NetworkBuffer.DIRECTION);
    }

    public static Entry<UUID> OptUUID(@Nullable UUID value) {
        return new MetadataImpl.EntryImpl<UUID>(13, value, NetworkBuffer.OPT_UUID);
    }

    public static Entry<Integer> BlockState(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(14, value, NetworkBuffer.BLOCK_STATE);
    }

    public static Entry<Integer> OptBlockState(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(15, value, NetworkBuffer.OPT_BLOCK_STATE);
    }

    public static Entry<NBT> NBT(@NotNull NBT nbt) {
        return new MetadataImpl.EntryImpl<NBT>(16, nbt, NetworkBuffer.NBT);
    }

    public static Entry<int[]> VillagerData(int villagerType, int villagerProfession, int level) {
        return new MetadataImpl.EntryImpl<int[]>(18, new int[]{villagerType, villagerProfession, level}, NetworkBuffer.VILLAGER_DATA);
    }

    public static Entry<Integer> OptVarInt(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(19, value, new NetworkBuffer.Type<Integer>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Integer value) {
                buffer.write(NetworkBuffer.VAR_INT, value == null ? 0 : value + 1);
            }

            @Override
            public Integer read(@NotNull NetworkBuffer buffer) {
                return buffer.read(NetworkBuffer.VAR_INT) - 1;
            }
        });
    }

    public static Entry<Entity.Pose> Pose(@NotNull Entity.Pose value) {
        return new MetadataImpl.EntryImpl<Entity.Pose>(20, value, NetworkBuffer.POSE);
    }

    public static Entry<CatMeta.Variant> CatVariant(@NotNull CatMeta.Variant value) {
        return new MetadataImpl.EntryImpl<CatMeta.Variant>(21, value, NetworkBuffer.CAT_VARIANT);
    }

    public static Entry<FrogMeta.Variant> FrogVariant(@NotNull FrogMeta.Variant value) {
        return new MetadataImpl.EntryImpl<FrogMeta.Variant>(22, value, NetworkBuffer.FROG_VARIANT);
    }

    public static Entry<PaintingMeta.Variant> PaintingVariant(@NotNull PaintingMeta.Variant value) {
        return new MetadataImpl.EntryImpl<PaintingMeta.Variant>(24, value, NetworkBuffer.PAINTING_VARIANT);
    }

    public static Entry<SnifferMeta.State> SnifferState(@NotNull SnifferMeta.State value) {
        return new MetadataImpl.EntryImpl<SnifferMeta.State>(25, value, NetworkBuffer.SNIFFER_STATE);
    }

    public static Entry<Point> Vector3(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(26, value, NetworkBuffer.VECTOR3);
    }

    public static Entry<float[]> Quaternion(float @NotNull [] value) {
        return new MetadataImpl.EntryImpl<float[]>(27, value, NetworkBuffer.QUATERNION);
    }

    public static Entry<Particle> Particle(@NotNull Particle particle) {
        return new MetadataImpl.EntryImpl<Particle>(17, particle, NetworkBuffer.PARTICLE);
    }

    public Metadata(@Nullable Entity entity) {
        this.entity = entity;
    }

    public <T> T getIndex(int index, @Nullable T defaultValue) {
        Entry<?>[] entries = this.entries;
        if (index < 0 || index >= entries.length) {
            return defaultValue;
        }
        Entry<?> entry = entries[index];
        return (T)(entry != null ? entry.value() : defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndex(int index, @NotNull Entry<?> entry) {
        Entry<?>[] entries = this.entries;
        if (index >= entries.length) {
            int newLength = Math.max(entries.length * 2, index + 1);
            this.entries = entries = Arrays.copyOf(entries, newLength);
        }
        entries[index] = entry;
        this.entryMap = null;
        Entity entity = this.entity;
        if (entity != null && entity.isActive()) {
            if (!this.notifyAboutChanges) {
                Map<Integer, Entry<?>> map = this.notNotifiedChanges;
                synchronized (map) {
                    this.notNotifiedChanges.put(index, entry);
                }
            } else {
                entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), Map.of(index, entry)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyAboutChanges(boolean notifyAboutChanges) {
        Map<Integer, Entry<?>> entries;
        if (!NOTIFIED_CHANGES.compareAndSet(this, !notifyAboutChanges, notifyAboutChanges)) {
            return;
        }
        if (!notifyAboutChanges) {
            return;
        }
        Entity entity = this.entity;
        if (entity == null || !entity.isActive()) {
            return;
        }
        Map<Integer, Entry<?>> map = this.notNotifiedChanges;
        synchronized (map) {
            Map<Integer, Entry<?>> awaitingChanges = this.notNotifiedChanges;
            if (awaitingChanges.isEmpty()) {
                return;
            }
            entries = Map.copyOf(awaitingChanges);
            awaitingChanges.clear();
        }
        entity.sendPacketToViewersAndSelf(new EntityMetaDataPacket(entity.getEntityId(), entries));
    }

    @NotNull
    public Map<Integer, Entry<?>> getEntries() {
        Map<Integer, Entry<?>> map = this.entryMap;
        if (map == null) {
            map = new HashMap();
            Entry<?>[] entries = this.entries;
            for (int i = 0; i < entries.length; ++i) {
                Entry<?> entry = entries[i];
                if (entry == null) continue;
                map.put(i, entry);
            }
            this.entryMap = Map.copyOf(map);
        }
        return map;
    }

    static {
        try {
            NOTIFIED_CHANGES = MethodHandles.lookup().findVarHandle(Metadata.class, "notifyAboutChanges", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static sealed interface Entry<T>
    extends NetworkBuffer.Writer
    permits MetadataImpl.EntryImpl {
        public int type();

        public @UnknownNullability T value();

        @ApiStatus.Internal
        @NotNull
        public static Entry<?> read(int type, @NotNull NetworkBuffer reader) {
            return MetadataImpl.EntryImpl.read(type, reader);
        }
    }
}

