/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.minestom.server.item.component.FireworkExplosion;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record FireworkList(byte flightDuration, @NotNull List<FireworkExplosion> explosions) {
    public static final FireworkList EMPTY = new FireworkList(0, List.of());
    public static final NetworkBuffer.Type<FireworkList> NETWORK_TYPE = new NetworkBuffer.Type<FireworkList>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, FireworkList value) {
            buffer.write(NetworkBuffer.BYTE, value.flightDuration);
            buffer.writeCollection(FireworkExplosion.NETWORK_TYPE, value.explosions);
        }

        @Override
        public FireworkList read(@NotNull NetworkBuffer buffer) {
            return new FireworkList(buffer.read(NetworkBuffer.BYTE), buffer.readCollection(FireworkExplosion.NETWORK_TYPE, 256));
        }
    };
    public static final BinaryTagSerializer<FireworkList> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        byte flightDuration = tag.getByte("flight_duration");
        ListBinaryTag explosionsTag = tag.getList("explosions", BinaryTagTypes.COMPOUND);
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>(explosionsTag.size());
        for (BinaryTag explosionTag : explosionsTag) {
            explosions.add(FireworkExplosion.NBT_TYPE.read(explosionTag));
        }
        return new FireworkList(flightDuration, explosions);
    }, value -> {
        ListBinaryTag.Builder explosionsTag = ListBinaryTag.builder();
        for (FireworkExplosion explosion : value.explosions) {
            explosionsTag.add(FireworkExplosion.NBT_TYPE.write(explosion));
        }
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putByte("flight_duration", value.flightDuration)).put("explosions", (BinaryTag)explosionsTag.build())).build();
    });

    public FireworkList(byte flightDuration, @NotNull List<FireworkExplosion> explosions) {
        explosions = List.copyOf(explosions);
    }

    @NotNull
    public FireworkList withFlightDuration(byte flightDuration) {
        return new FireworkList(flightDuration, this.explosions);
    }

    @NotNull
    public FireworkList withExplosions(@NotNull List<FireworkExplosion> explosions) {
        return new FireworkList(this.flightDuration, explosions);
    }
}

