/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.Color;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record FireworkExplosion(@NotNull Shape shape, @NotNull List<RGBLike> colors, @NotNull List<RGBLike> fadeColors, boolean hasTrail, boolean hasTwinkle) {
    public static final NetworkBuffer.Type<FireworkExplosion> NETWORK_TYPE = new NetworkBuffer.Type<FireworkExplosion>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, FireworkExplosion value) {
            buffer.writeEnum(Shape.class, value.shape);
            buffer.writeCollection(Color.NETWORK_TYPE, value.colors);
            buffer.writeCollection(Color.NETWORK_TYPE, value.fadeColors);
            buffer.write(NetworkBuffer.BOOLEAN, value.hasTrail);
            buffer.write(NetworkBuffer.BOOLEAN, value.hasTwinkle);
        }

        @Override
        public FireworkExplosion read(@NotNull NetworkBuffer buffer) {
            return new FireworkExplosion(buffer.readEnum(Shape.class), buffer.readCollection(Color.NETWORK_TYPE, Short.MAX_VALUE), buffer.readCollection(Color.NETWORK_TYPE, Short.MAX_VALUE), buffer.read(NetworkBuffer.BOOLEAN), buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
    public static final BinaryTagSerializer<FireworkExplosion> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        Shape shape = Shape.valueOf(tag.getString("shape").toUpperCase(Locale.ROOT));
        ArrayList<RGBLike> colors = new ArrayList<RGBLike>();
        for (int color : tag.getIntArray("colors")) {
            colors.add(new Color(color));
        }
        ArrayList<RGBLike> fadeColors = new ArrayList<RGBLike>();
        for (int fadeColor : tag.getIntArray("fade_colors")) {
            fadeColors.add(new Color(fadeColor));
        }
        boolean hasTrail = tag.getBoolean("has_trail");
        boolean hasTwinkle = tag.getBoolean("has_twinkle");
        return new FireworkExplosion(shape, colors, fadeColors, hasTrail, hasTwinkle);
    }, value -> {
        int i;
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        builder.putString("shape", value.shape.name().toLowerCase(Locale.ROOT));
        if (!value.colors.isEmpty()) {
            int[] colors = new int[value.colors.size()];
            for (i = 0; i < value.colors.size(); ++i) {
                colors[i] = Color.fromRGBLike(value.colors.get(i)).asRGB();
            }
            builder.putIntArray("colors", colors);
        }
        if (!value.fadeColors.isEmpty()) {
            int[] fadeColors = new int[value.fadeColors.size()];
            for (i = 0; i < value.fadeColors.size(); ++i) {
                fadeColors[i] = Color.fromRGBLike(value.fadeColors.get(i)).asRGB();
            }
            builder.putIntArray("fade_colors", fadeColors);
        }
        if (value.hasTrail) {
            builder.putBoolean("has_trail", value.hasTrail);
        }
        if (value.hasTwinkle) {
            builder.putBoolean("has_twinkle", value.hasTwinkle);
        }
        return builder.build();
    });

    public FireworkExplosion(@NotNull Shape shape, @NotNull List<RGBLike> colors, @NotNull List<RGBLike> fadeColors, boolean hasTrail, boolean hasTwinkle) {
        colors = List.copyOf(colors);
        fadeColors = List.copyOf(fadeColors);
    }

    public static enum Shape {
        SMALL_BALL,
        LARGE_BALL,
        STAR,
        CREEPER,
        BURST;

    }
}

