/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.RecipeCategory;
import net.minestom.server.recipe.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ShapedRecipe
extends Recipe {
    private final int width;
    private final int height;
    private String group;
    private RecipeCategory.Crafting category;
    private final List<DeclareRecipesPacket.Ingredient> ingredients;
    private ItemStack result;
    private boolean showNotification;

    protected ShapedRecipe(@NotNull String recipeId, int width, int height, @NotNull String group, @NotNull RecipeCategory.Crafting category, @Nullable List<DeclareRecipesPacket.Ingredient> ingredients, @NotNull ItemStack result, boolean showNotification) {
        super(RecipeType.SHAPED, recipeId);
        this.width = width;
        this.height = height;
        this.group = group;
        this.category = category;
        this.ingredients = Objects.requireNonNullElseGet(ingredients, LinkedList::new);
        this.result = result;
        this.showNotification = showNotification;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotNull String group) {
        this.group = group;
    }

    @NotNull
    public RecipeCategory.Crafting getCategory() {
        return this.category;
    }

    public void setCategory(@NotNull RecipeCategory.Crafting category) {
        this.category = category;
    }

    public void addIngredient(DeclareRecipesPacket.Ingredient ingredient) {
        if (this.ingredients.size() + 1 > this.width * this.height) {
            throw new IndexOutOfBoundsException("You cannot add more ingredients than width*height");
        }
        this.ingredients.add(ingredient);
    }

    @NotNull
    public List<DeclareRecipesPacket.Ingredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    public boolean getShowNotification() {
        return this.showNotification;
    }

    public void setShowNotification(boolean showNotification) {
        this.showNotification = showNotification;
    }
}

