/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.particle;

import java.util.Collection;
import net.minestom.server.color.Color;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemStack;
import net.minestom.server.particle.Particle;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;

final class ParticleImpl {
    private static final Registry.Container<Particle> CONTAINER = Registry.createStaticContainer(Registry.Resource.PARTICLES, (namespace, properties) -> ParticleImpl.defaultParticle(NamespaceID.from(namespace), properties.getInt("id")));

    static Particle get(@NotNull String namespace) {
        return CONTAINER.get(namespace);
    }

    static Particle getSafe(@NotNull String namespace) {
        return CONTAINER.getSafe(namespace);
    }

    static Particle getId(int id) {
        return CONTAINER.getId(id);
    }

    static Collection<Particle> values() {
        return CONTAINER.values();
    }

    private static Particle defaultParticle(@NotNull NamespaceID namespace, int id) {
        return switch (namespace.asString()) {
            case "minecraft:block" -> new Particle.Block(namespace, id, Block.STONE);
            case "minecraft:block_marker" -> new Particle.BlockMarker(namespace, id, Block.STONE);
            case "minecraft:falling_dust" -> new Particle.FallingDust(namespace, id, Block.STONE);
            case "minecraft:dust_pillar" -> new Particle.DustPillar(namespace, id, Block.STONE);
            case "minecraft:dust" -> new Particle.Dust(namespace, id, new Color(255, 255, 255), 1.0f);
            case "minecraft:dust_color_transition" -> new Particle.DustColorTransition(namespace, id, new Color(255, 255, 255), new Color(255, 255, 255), 1.0f);
            case "minecraft:sculk_charge" -> new Particle.SculkCharge(namespace, id, 0.0f);
            case "minecraft:item" -> new Particle.Item(namespace, id, ItemStack.AIR);
            case "minecraft:vibration" -> new Particle.Vibration(namespace, id, Particle.Vibration.SourceType.BLOCK, Vec.ZERO, 0, 0.0f, 0);
            case "minecraft:shriek" -> new Particle.Shriek(namespace, id, 0);
            case "minecraft:entity_effect" -> new Particle.EntityEffect(namespace, id, new Color(0));
            default -> new Particle.Simple(namespace, id);
        };
    }

    private ParticleImpl() {
    }
}

