/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.metadata.EntityMeta;
import org.jetbrains.annotations.NotNull;

public class BoatMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 15;

    public BoatMeta(@NotNull Entity entity, @NotNull Metadata metadata) {
        super(entity, metadata);
    }

    public int getTimeSinceLastHit() {
        return this.metadata.getIndex(8, 0);
    }

    public void setTimeSinceLastHit(int value) {
        this.metadata.setIndex(8, Metadata.VarInt(value));
    }

    public int getForwardDirection() {
        return this.metadata.getIndex(9, 1);
    }

    public void setForwardDirection(int value) {
        this.metadata.setIndex(9, Metadata.VarInt(value));
    }

    public float getDamageTaken() {
        return this.metadata.getIndex(10, 0).intValue();
    }

    public void setDamageTaken(float value) {
        this.metadata.setIndex(10, Metadata.Float(value));
    }

    @NotNull
    public Type getType() {
        return Type.VALUES[this.metadata.getIndex(11, 0)];
    }

    public void setType(@NotNull Type value) {
        this.metadata.setIndex(11, Metadata.VarInt(value.ordinal()));
    }

    public boolean isLeftPaddleTurning() {
        return this.metadata.getIndex(12, false);
    }

    public void setLeftPaddleTurning(boolean value) {
        this.metadata.setIndex(12, Metadata.Boolean(value));
    }

    public boolean isRightPaddleTurning() {
        return this.metadata.getIndex(13, false);
    }

    public void setRightPaddleTurning(boolean value) {
        this.metadata.setIndex(13, Metadata.Boolean(value));
    }

    public int getSplashTimer() {
        return this.metadata.getIndex(14, 0);
    }

    public void setSplashTimer(int value) {
        this.metadata.setIndex(14, Metadata.VarInt(value));
    }

    public static enum Type {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        CHERRY,
        DARK_OAK,
        MANGROVE,
        BAMBOO;

        private static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

