/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import net.minestom.server.MinecraftServer;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.ShapeImpl;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.metadata.projectile.ProjectileMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityShootEvent;
import net.minestom.server.event.entity.projectile.ProjectileCollideWithBlockEvent;
import net.minestom.server.event.entity.projectile.ProjectileCollideWithEntityEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import org.jetbrains.annotations.NotNull;

public class PlayerProjectile
extends Entity {
    private final Entity shooter;
    private long cooldown = 0L;

    public PlayerProjectile(Entity shooter, EntityType type) {
        super(type);
        this.shooter = shooter;
        this.hasCollision = false;
        this.setup();
    }

    private void setup() {
        this.hasPhysics = false;
        if (this.getEntityMeta() instanceof ProjectileMeta) {
            ((ProjectileMeta)((Object)this.getEntityMeta())).setShooter(this.shooter);
        }
    }

    public void shoot(Point from, double power, double spread) {
        Point to = from.add(this.shooter.getPosition().direction());
        this.shoot(from, to, power, spread);
    }

    @Override
    public CompletableFuture<Void> setInstance(@NotNull Instance instance, @NotNull Pos spawnPosition) {
        CompletableFuture<Void> res = super.setInstance(instance, spawnPosition);
        Pos insideBlock = this.checkInsideBlock(instance);
        if (insideBlock != null) {
            ProjectileCollideWithBlockEvent e = new ProjectileCollideWithBlockEvent(this, Pos.fromPoint(spawnPosition), instance.getBlock(spawnPosition));
            MinecraftServer.getGlobalEventHandler().call(e);
        }
        return res;
    }

    public void shoot(@NotNull Point from, @NotNull Point to, double power, double spread) {
        Instance instance = this.shooter.getInstance();
        if (instance == null) {
            return;
        }
        float yaw = -this.shooter.getPosition().yaw();
        float pitch = -this.shooter.getPosition().pitch();
        double pitchDiff = pitch - 45.0f;
        if (pitchDiff == 0.0) {
            pitchDiff = 1.0E-4;
        }
        double pitchAdjust = pitchDiff * 0.002145329238474369;
        double dx = to.x() - from.x();
        double dy = to.y() - from.y() + pitchAdjust;
        double dz = to.z() - from.z();
        if (!this.hasNoGravity()) {
            double xzLength = Math.sqrt(dx * dx + dz * dz);
            dy += xzLength * (double)0.2f;
        }
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= length;
        dy /= length;
        dz /= length;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        dx += random.nextGaussian() * (spread *= (double)0.0075f);
        dy += random.nextGaussian() * spread;
        dz += random.nextGaussian() * spread;
        EntityShootEvent shootEvent = new EntityShootEvent(this.shooter, this, from, power, spread);
        EventDispatcher.call(shootEvent);
        if (shootEvent.isCancelled()) {
            this.remove();
            return;
        }
        double mul = 20.0 * power;
        Vec v = new Vec(dx * mul, dy * mul * 0.9, dz * mul);
        this.setInstance(instance, new Pos(from.x(), from.y(), from.z(), yaw, pitch)).whenComplete((result, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                this.setVelocity(v);
            }
        });
        this.cooldown = System.currentTimeMillis();
    }

    private Pos checkInsideBlock(@NotNull Instance instance) {
        BoundingBox.PointIterator iterator = this.getBoundingBox().getBlocks(this.getPosition());
        while (iterator.hasNext()) {
            BoundingBox.MutablePoint block = iterator.next();
            Block b = instance.getBlock(block.blockX(), block.blockY(), block.blockZ());
            boolean hit = b.registry().collisionShape().intersectBox(this.getPosition().sub(block.x(), block.y(), block.z()), this.getBoundingBox());
            if (!hit) continue;
            return new Pos(block.blockX(), (double)block.blockY(), (double)block.blockZ());
        }
        return null;
    }

    @Override
    public void refreshPosition(@NotNull Pos newPosition) {
    }

    @Override
    public void tick(long time) {
        Shape shape;
        PhysicsResult collided;
        Pos posBefore = this.getPosition();
        super.tick(time);
        if (super.isRemoved()) {
            return;
        }
        Pos posNow = this.getPosition();
        Vec diff = Vec.fromPoint(posNow.sub(posBefore));
        PhysicsResult result = CollisionUtils.handlePhysics(this.instance, this.getChunk(), this.getBoundingBox(), posBefore, diff, null, true);
        if (this.cooldown + 500L < System.currentTimeMillis()) {
            float yaw = (float)Math.toDegrees(Math.atan2(diff.x(), diff.z()));
            float pitch = (float)Math.toDegrees(Math.atan2(diff.y(), Math.sqrt(diff.x() * diff.x() + diff.z() * diff.z())));
            super.refreshPosition(new Pos(posNow.x(), posNow.y(), posNow.z(), yaw, pitch));
            this.cooldown = System.currentTimeMillis();
        }
        if ((collided = CollisionUtils.checkEntityCollisions(this.instance, this.getBoundingBox(), posBefore, diff, 3.0, e -> e != this, result)) != null && collided.collisionShapes()[0] != this.shooter && (shape = collided.collisionShapes()[0]) instanceof Entity) {
            Entity entity = (Entity)shape;
            ProjectileCollideWithEntityEvent e2 = new ProjectileCollideWithEntityEvent(this, collided.newPosition(), entity);
            MinecraftServer.getGlobalEventHandler().call(e2);
            return;
        }
        if (result.hasCollision()) {
            ShapeImpl block;
            Block hitBlock = null;
            Point hitPoint = null;
            Shape shape2 = result.collisionShapes()[0];
            if (shape2 instanceof ShapeImpl) {
                block = (ShapeImpl)shape2;
                hitBlock = block.block();
                hitPoint = result.collisionPoints()[0];
            }
            if ((shape2 = result.collisionShapes()[1]) instanceof ShapeImpl) {
                block = (ShapeImpl)shape2;
                hitBlock = block.block();
                hitPoint = result.collisionPoints()[1];
            }
            if ((shape2 = result.collisionShapes()[2]) instanceof ShapeImpl) {
                block = (ShapeImpl)shape2;
                hitBlock = block.block();
                hitPoint = result.collisionPoints()[2];
            }
            if (hitBlock == null) {
                return;
            }
            ProjectileCollideWithBlockEvent e3 = new ProjectileCollideWithBlockEvent(this, Pos.fromPoint(hitPoint), hitBlock);
            MinecraftServer.getGlobalEventHandler().call(e3);
        }
    }
}

